---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：142-ヘルプシステム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **HugoTransformerの詳細動作**：ライブラリコード直接確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/help_controller.rb` - ヘルプコントローラ
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（行143）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（行377-380）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 認証スキップ条件がある | E-01 (4行目) | ○ |
| C-02 | 2FA要求をスキップ | E-01 (5行目) | ○ |
| C-03 | helpレイアウトを使用 | E-01 (8行目) | ○ |
| C-04 | YAML Front Matter正規表現定義 | E-01 (12行目) | ○ |
| C-05 | indexでリンク変換処理 | E-01 (20-22行目) | ○ |
| C-06 | showで複数形式対応 | E-01 (28-51行目) | ○ |
| C-07 | メディアファイル配信対応 | E-01 (38-47行目) | ○ |
| C-08 | 外部ドキュメントリダイレクト | E-01 (92-94行目) | ○ |
| C-09 | documentation_base_url_from_db (DEPRECATED) | E-01 (107-109行目) | ○ |
| C-10 | gitlab_docs設定からURL取得 | E-01 (111-113行目) | ○ |
| C-11 | バージョンセグメント生成 | E-01 (121-126行目) | ○ |
| C-12 | drawersアクション存在 | E-01 (64-73行目) | ○ |
| C-13 | パストラバーサル対策 | E-01 (26行目, 65行目) | ○ |
| C-14 | instance_configurationアクション | E-01 (60-62行目) | ○ |
| C-15 | index.md / _index.md 代替検索 | E-01 (149-151行目) | ○ |
| C-16 | HugoTransformerによる変換 | **根拠なし（参照のみ）** | △ |

## 4) 不足情報（Unknown / Missing）
- HugoTransformerの詳細実装
  - 候補：`lib/gitlab/help/hugo_transformer.rb`の直接確認

## 5) リスクフラグ（レビュー観点）
- 0: documentation_base_url_from_dbがDEPRECATED（将来的に削除予定）
- 0: feature_categoryがnot_owned（未分類状態）

## 6) レビュアーチェックリスト（最小）
- [ ] 外部ドキュメントURLの設定方法を確認
- [ ] パストラバーサル対策の十分性を確認
- [ ] HugoTransformerの変換ルールを確認
- [ ] メディアファイル配信のセキュリティを確認
