---
generated_at: 2026-01-22 14:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：143-ヘルスチェック

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。追加レビュー不要。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/health_controller.rb` - ヘルスチェックコントローラ
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（行144）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（行277-278等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseActionControllerを継承 | E-01 (3行目) | ○ |
| C-02 | CSRF保護設定 | E-01 (4行目) | ○ |
| C-03 | RequiresAllowlistedMonitoringClient concern | E-01 (5行目) | ○ |
| C-04 | CHECKS定数でMasterCheckのみ定義 | E-01 (7-9行目) | ○ |
| C-05 | ALL_CHECKSで全チェック定義 | E-01 (11-16行目) | ○ |
| C-06 | readinessでparams[:all]によりチェック範囲決定 | E-01 (21行目) | ○ |
| C-07 | livenessはチェックなし | E-01 (26行目) | ○ |
| C-08 | Probes::Collectionでチェック実行 | E-01 (32-34行目) | ○ |
| C-09 | 失敗時にX-GitLab-Custom-Errorヘッダ設定 | E-01 (37行目) | ○ |
| C-10 | JSON形式でレスポンス | E-01 (39行目) | ○ |
| C-11 | DbCheckが含まれる | E-01 (13行目) | ○ |
| C-12 | Redisチェックが含まれる | E-01 (14行目) | ○ |
| C-13 | GitalyCheckが含まれる | E-01 (15行目) | ○ |
| C-14 | result.http_statusで応答コード決定 | E-01 (39行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目がコードで確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。シンプルな構造で理解しやすい。

## 6) レビュアーチェックリスト（最小）
- [ ] 許可リスト設定の運用方法を確認
- [ ] Kubernetesプローブ設定との整合性を確認
- [ ] 各チェッククラスの実装詳細を必要に応じて確認
