---
generated_at: 2026-01-22 14:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：147-ハウスキーピング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **コントローラ実装の行番号**：正確な行番号は変動の可能性あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/repositories/housekeeping_service.rb` - ハウスキーピングサービス
- E-02: `app/controllers/projects_controller.rb` - プロジェクトコントローラ（Grep結果）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（行148）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LEASE_TIMEOUT = 86400 (24時間) | E-01 (12行目) | ○ |
| C-02 | GC_PERIOD = 200 | E-01 (13行目) | ○ |
| C-03 | LeaseTaken例外クラス | E-01 (15-18行目) | ○ |
| C-04 | execute メソッド | E-01 (26-33行目) | ○ |
| C-05 | needed? メソッド | E-01 (35-37行目) | ○ |
| C-06 | increment! メソッド | E-01 (39-43行目) | ○ |
| C-07 | execute_gitlab_shell_gc | E-01 (47-55行目) | ○ |
| C-08 | try_obtain_lease | E-01 (57-62行目) | ○ |
| C-09 | task 自動決定ロジック | E-01 (72-80行目) | ○ |
| C-10 | period_match? | E-01 (82-84行目) | ○ |
| C-11 | housekeeping_enabled? | E-01 (86-88行目) | ○ |
| C-12 | housekeepingアクションでタスク決定 | E-02 (264-269行目) | ○ |
| C-13 | 監査ログ記録 | E-02 (272-277行目) | ○ |
| C-14 | pruneパラメータ処理 | E-02 (265-268行目) | ○ |
| C-15 | コントローラの正確な行番号 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- コントローラの正確な行番号（Grepで確認したが完全一致は未確認）
  - 候補：projects_controller.rbの直接確認

## 5) リスクフラグ（レビュー観点）
- 0: サービス実装は詳細に確認済み
- 0: 主要なロジックは全て根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] housekeeping_incremental_repack_period設定の確認
- [ ] GitGarbageCollectWorkerの詳細実装を確認
- [ ] Gitalyとの連携方法を確認
