---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：148-バッジ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **SVGテンプレートの詳細**：テンプレートファイルの直接確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/badges_controller.rb` - バッジコントローラ
- E-02: `lib/gitlab/ci/badge/pipeline/status.rb` - パイプラインステータスバッジ
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（行149）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（行170, 235）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | authorize_admin_project!（indexアクション） | E-01 (5行目) | ○ |
| C-02 | no_cache_headers | E-01 (6行目) | ○ |
| C-03 | authorize_read_build!（pipeline, coverage） | E-01 (7行目) | ○ |
| C-04 | feature_category設定 | E-01 (9-12行目) | ○ |
| C-05 | pipelineアクション実装 | E-01 (14-23行目) | ○ |
| C-06 | coverageアクション実装 | E-01 (25-37行目) | ○ |
| C-07 | releaseアクション実装 | E-01 (39-49行目) | ○ |
| C-08 | customアクションのFeature Flag | E-01 (52行目) | ○ |
| C-09 | badge_layoutのスタイル判定 | E-01 (69-78行目) | ○ |
| C-10 | render_badgeでSVGレンダリング | E-01 (80-87行目) | ○ |
| C-11 | Pipeline::Status初期化 | E-02 (12-19行目) | ○ |
| C-12 | statusメソッドでステータス取得 | E-02 (26-29行目) | ○ |
| C-13 | ignore_skippedオプション | E-02 (15行目, 28行目) | ○ |
| C-14 | カスタマイズオプション（key_width, key_text） | E-02 (16-18行目) | ○ |
| C-15 | format.svg/format.htmlの分岐 | E-01 (81-86行目) | ○ |
| C-16 | SVGテンプレートの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- SVGテンプレートの詳細実装
  - 候補：`app/views/projects/badges/*.svg.erb`の直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 主要なロジックは確認済み
- 1: カスタムバッジはFeature Flagで制御されている点に注意

## 6) レビュアーチェックリスト（最小）
- [ ] SVGテンプレートの実装を確認
- [ ] カバレッジ色判定ロジックを確認
- [ ] Feature Flag (custom_project_badges) の運用状況を確認
