---
generated_at: 2026-01-22 14:40:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：149-イシュー/MRテンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **MergeRequestTemplateクラス**：直接確認なし（IssueTemplateと同様の構造と推定）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/templates_controller.rb` - テンプレートコントローラ
- E-02: `lib/gitlab/template/issue_template.rb` - イシューテンプレートクラス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（行150）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング（行74, 93, 268）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | authenticate_user!が必須 | E-01 (4行目) | ○ |
| C-02 | authorize_can_read_issuable!で権限確認 | E-01 (5行目) | ○ |
| C-03 | get_template_classでクラス決定 | E-01 (6行目) | ○ |
| C-04 | feature_category: source_code_management | E-01 (8行目) | ○ |
| C-05 | urgency: low (namesアクション) | E-01 (9行目) | ○ |
| C-06 | indexでtemplate_subsets使用 | E-01 (12行目) | ○ |
| C-07 | showでfind使用 | E-01 (20行目) | ○ |
| C-08 | namesでall_template_names使用 | E-01 (29行目) | ○ |
| C-09 | template_typesの定義 | E-01 (48行目) | ○ |
| C-10 | IssueTemplate.extension = '.md' | E-02 (7-8行目) | ○ |
| C-11 | IssueTemplate.base_dir = '.gitlab/issue_templates/' | E-02 (11-12行目) | ○ |
| C-12 | finder でRepoTemplateFinderを使用 | E-02 (15-16行目) | ○ |
| C-13 | template_namesでキャッシュ活用 | E-02 (19-27行目) | ○ |
| C-14 | MergeRequestTemplateの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MergeRequestTemplateクラスの詳細実装
  - 候補：`lib/gitlab/template/merge_request_template.rb`の直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 主要なロジックは確認済み
- 0: IssueTemplateとMergeRequestTemplateは同様の構造と推定

## 6) レビュアーチェックリスト（最小）
- [ ] MergeRequestTemplateクラスの実装を確認
- [ ] TemplateFinder.all_template_namesの実装を確認
- [ ] リポジトリキャッシュの挙動を確認
