---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：15-ファイル閲覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **コードナビゲーション（LSIF）の詳細**：連携方法の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/blob_controller.rb` - BlobController
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | read_code権限が必要 | E-01 (25行目: authorize_read_code!) | ○ |
| C-02 | showアクションがエントリーポイント | E-01 (71-85行目) | ○ |
| C-03 | MAX_EDIT_SIZE = 10MB | E-01 (17行目) | ○ |
| C-04 | MAX_PREVIEW_CONTENT = 512KB | E-01 (16行目) | ○ |
| C-05 | blobメソッドでBlob取得 | E-01 (185-190行目) | ○ |
| C-06 | require_blobでBlob存在チェック | E-01 (38行目, 192-194行目) | ○ |
| C-07 | Blobがなければツリー表示へリダイレクト | E-01 (196-202行目) | ○ |
| C-08 | show_htmlで環境情報取得 | E-01 (299-311行目) | ○ |
| C-09 | show_jsonでJSON返却 | E-01 (313-335行目) | ○ |
| C-10 | 最終コミット情報の取得 | E-01 (307行目: @last_commit) | ○ |
| C-11 | コードナビゲーションパス取得 | E-01 (308行目: @code_navigation_path) | ○ |
| C-12 | editアクションでファイルサイズチェック | E-01 (87-98行目) | ○ |
| C-13 | 大きなファイルはブラウザ編集不可 | E-01 (89-91行目) | ○ |
| C-14 | previewアクションでプレビュー表示 | E-01 (115-129行目) | ○ |
| C-15 | diffアクションで差分表示 | E-01 (140-152行目) | ○ |
| C-16 | 関連画面: ファイル表示 | E-03 (画面No 31) | ○ |
| C-17 | 関連画面: Blame表示 | E-03 (画面No 34) | ○ |
| C-18 | 機能カテゴリ: ソースコード管理 | E-02 (No.15) | ○ |
| C-19 | feature_category: source_code_management | E-01 (47行目) | ○ |
| C-20 | allow_gitaly_ref_name_caching有効化 | E-01 (21行目) | ○ |
| C-21 | set_last_commit_shaで最終コミットSHA設定 | E-01 (294-297行目) | ○ |
| C-22 | コードナビゲーション（LSIF）連携 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- コードナビゲーション（LSIF）連携の詳細
  - 候補：`lib/gitlab/code_navigation_path.rb` / LSIF関連ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェックロジック - コード上で確認済み
- 0: Blob取得ロジック - 明確に実装されている
- 1: LFSファイルの取り扱い - 追加確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] authorize_read_code!の実装が適切か確認
- [ ] ファイルサイズ制限の値が適切か確認
- [ ] バイナリファイル判定ロジックを確認
- [ ] LFSファイル取得処理を確認
- [ ] コードナビゲーションの動作を確認
