---
generated_at: 2026-01-22 14:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：150-オートコンプリート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ParticipantsServiceの詳細**：直接確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/autocomplete_sources_controller.rb` - オートコンプリートコントローラ
- E-02: `app/services/projects/autocomplete_service.rb` - オートコンプリートサービス
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（行151）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | authorize_read_milestone! | E-01 (6行目) | ○ |
| C-02 | authorize_read_crm_contact! | E-01 (7行目) | ○ |
| C-03 | feature_category設定 | E-01 (9-13行目) | ○ |
| C-04 | urgency: low設定 | E-01 (15-16行目) | ○ |
| C-05 | membersでParticipantsService使用 | E-01 (18-19行目) | ○ |
| C-06 | issuesでautocomplete_service.issues | E-01 (22-23行目) | ○ |
| C-07 | autocomplete_serviceでorganization_id追加 | E-01 (60行目) | ○ |
| C-08 | QuickActions::TargetServiceでtarget取得 | E-01 (70-72行目) | ○ |
| C-09 | authorize_read_crm_contact!の実装 | E-01 (75-77行目) | ○ |
| C-10 | SEARCH_LIMIT = 5 | E-02 (8行目) | ○ |
| C-11 | IssuesFinderでオープンイシュー取得 | E-02 (11行目) | ○ |
| C-12 | gfm_autocomplete_search使用 | E-02 (12行目) | ○ |
| C-13 | MilestonesFinderでアクティブマイルストーン取得 | E-02 (18-27行目) | ○ |
| C-14 | MergeRequestsFinderでオープンMR取得 | E-02 (30-31行目) | ○ |
| C-15 | QuickActions::InterpretServiceでコマンド取得 | E-02 (37行目) | ○ |
| C-16 | Wiki除外パス（templates/, uploads/） | E-02 (54行目) | ○ |
| C-17 | CRM連絡先取得 | E-02 (58-73行目) | ○ |
| C-18 | ParticipantsServiceの詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ParticipantsServiceの詳細実装
  - 候補：`app/services/projects/participants_service.rb`の直接確認

## 5) リスクフラグ（レビュー観点）
- 0: 主要なロジックは確認済み
- 1: 組織IDスコープの影響範囲を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ParticipantsServiceの実装を確認
- [ ] ExpiresIn concernのキャッシュヘッダ設定を確認
- [ ] 各Finderの検索ロジックを確認
