---
generated_at: 2026-01-22 13:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：19-ブランチ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **アクティブ/古いブランチの判定基準**：具体的な日数確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/branches_controller.rb` - BranchesController
- E-02: `app/services/branches/create_service.rb` - CreateService
- E-03: `app/services/branches/delete_service.rb` - DeleteService
- E-04: `app/services/branches/delete_merged_service.rb` - DeleteMergedService
- E-05: `app/services/branches/validate_new_service.rb` - ValidateNewService
- E-06: `app/finders/branches_finder.rb` - BranchesFinder
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | read_code権限が必要（一覧） | E-01 (27行目: authorize_read_code!) | ○ |
| C-02 | push_code権限が必要（作成/削除） | E-01 (76行目: authorize_push_code!) | ○ |
| C-03 | indexアクションでブランチ一覧取得 | E-01 (19-54行目) | ○ |
| C-04 | createアクションでブランチ作成 | E-01 (76-119行目) | ○ |
| C-05 | destroyアクションでブランチ削除 | E-01 (122-136行目) | ○ |
| C-06 | destroy_all_mergedでマージ済み一括削除 | E-01 (138-144行目) | ○ |
| C-07 | Branches::CreateServiceでブランチ作成 | E-01 (82行目), E-02 | ○ |
| C-08 | repository.add_branch呼び出し | E-02 (78-104行目) | ○ |
| C-09 | ブランチ名バリデーション | E-05 (ValidateNewService) | ○ |
| C-10 | ref検証（validate_ref） | E-02 (41-50行目) | ○ |
| C-11 | Branches::DeleteServiceでブランチ削除 | E-01 (125行目), E-03 | ○ |
| C-12 | repository.rm_branch呼び出し | E-03 (31行目) | ○ |
| C-13 | マージ済みブランチ一括削除の非同期実行 | E-04 (async: true) | ○ |
| C-14 | BranchesFinderでブランチ検索 | E-06 | ○ |
| C-15 | 状態フィルタ（all/active/stale/overview） | E-01 (38行目: fetch_branches_by_mode) | ○ |
| C-16 | ソート順サポート（name/updated_asc/updated_desc） | E-06 (sort処理) | ○ |
| C-17 | 関連画面: ブランチ一覧 | E-08 (画面No 35) | ○ |
| C-18 | 関連画面: ブランチ新規作成 | E-08 (画面No 36) | ○ |
| C-19 | 機能カテゴリ: ソースコード管理 | E-07 (No.19) | ○ |
| C-20 | 保護ブランチの削除制限 | E-03 (check_access!) | ○ |
| C-21 | パイプライン状態表示 | E-01 (45行目: Ci::CommitStatusesFinder) | ○ |
| C-22 | アクティブ/古いブランチの判定基準 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- アクティブ/古いブランチの判定基準（具体的な日数）
  - 候補：`app/services/projects/branches_by_mode_service.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 権限チェックロジック - コード上で確認済み
- 0: ブランチ作成ロジック - 明確に実装されている
- 0: ブランチ削除ロジック - 明確に実装されている
- 1: アクティブ/古い判定 - 具体的な基準の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] authorize_read_code!/authorize_push_code!の実装が適切か確認
- [ ] ブランチ名バリデーションロジックを確認
- [ ] 保護ブランチの削除制限を確認
- [ ] マージ済みブランチ一括削除の非同期処理を確認
- [ ] アクティブ/古いブランチの判定基準を確認
