---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-プロジェクト編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects_controller.rb` - updateアクション（127-134行目）
- E-02: `app/services/projects/update_service.rb` - UpdateServiceクラス全体
- E-03: `app/services/projects/update_service.rb` - executeメソッド（12-47行目）
- E-04: `app/services/projects/update_service.rb` - validate!メソッド（73-84行目）
- E-05: `app/services/projects/update_service.rb` - validate_default_branch_change（111-133行目）
- E-06: `app/services/projects/update_service.rb` - validate_renaming_project_with_tags（135-155行目）
- E-07: `app/services/projects/update_service.rb` - after_update（227-256行目）
- E-08: `app/services/projects/update_service.rb` - remove_unallowed_params（219-225行目）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.2の定義
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.26との関連

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | updateアクションがProjects::UpdateServiceを呼び出す | E-01 | ○ |
| C-02 | 可視性レベル変更のバリデーションがある | E-04 (74行目) | ○ |
| C-03 | デフォルトブランチ変更の検証がある | E-05 | ○ |
| C-04 | コンテナレジストリタグ存在時のリネーム制限がある | E-06 | ○ |
| C-05 | パス変更時にAfterRenameServiceが実行される | E-07 (245-249行目) | ○ |
| C-06 | プライベート変更時にTodo削除がスケジュールされる | E-07 (237-243行目) | ○ |
| C-07 | システムフックが実行される | E-07 (248行目) | ○ |
| C-08 | Wiki有効化時にWikiが作成される | E-03 (20行目), E-02 (311-316行目) | ○ |
| C-09 | リポジトリストレージ移動がスケジュールできる | E-03 (22-28行目) | ○ |
| C-10 | 許可されないパラメータが削除される | E-08 | ○ |
| C-11 | max_artifacts_sizeはAdmin権限が必要 | E-08 (224行目) | ○ |
| C-12 | emails_enabledは権限チェックがある | E-08 (220行目) | ○ |
| C-13 | HEADブランチ競合時にエラーが発生する | E-05 (120-127行目) | ○ |
| C-14 | CRドライラン失敗時にエラーが返る | E-06 (142-154行目) | ○ |
| C-15 | パイプライン変数最小権限ロール変更の検証がある | E-04 (83行目), E-02 (97-109行目) | ○ |
| C-16 | Pagesアクセスレベルの検証がある | E-04 (82行目), E-02 (166-198行目) | ○ |
| C-17 | 可視性変更イベントが発行される | E-07 (255行目), E-02 (390-401行目) | ○ |
| C-18 | 機能変更イベントが発行される | E-07 (255行目), E-02 (375-388行目) | ○ |
| C-19 | ランナー設定変更時にペンディングビルドが更新される | E-07 (251行目), E-02 (337-346行目) | ○ |
| C-20 | 画面No.26がプロジェクト編集画面 | E-10 | ○ |
| C-21 | 機能No.2がプロジェクト編集機能 | E-09 | ○ |
| C-22 | トピック情報の構築処理がある | E-03 (13行目), E-02 (326-335行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータ一覧がコントローラーのpermitと一致しているか確認
- [ ] エラーケースがコード上のエラーハンドリングと一致しているか確認
- [ ] Container Registryリネームのドライラン仕様が最新APIと一致しているか確認
