---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-コミット閲覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「1秒以内」**：具体的な数値根拠なし
  2. **Atomフィード出力**：ビューテンプレートの確認推奨
  3. **署名検証機能**：signatures アクションの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/commits_controller.rb` - コミットコントローラー実装
- E-02: `app/controllers/concerns/extracts_path.rb` - パス抽出Concern
- E-03: `app/controllers/concerns/renders_commits.rb` - コミット描画Concern
- E-04: `app/controllers/concerns/parse_commit_date.rb` - 日付パースConcern
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルト表示件数は40件 | E-01: 11行目 COMMITS_DEFAULT_LIMIT = 40 | ○ |
| C-02 | 認証が必要なアクセスはフィーチャーフラグで制御 | E-01: 80-86行目 require_auth?, auth_for_path メソッド | ○ |
| C-03 | authorize_read_code! による権限確認 | E-01: 15行目 before_action :authorize_read_code! | ○ |
| C-04 | Atomフィード用のセッションレス認証 | E-01: 12行目 authenticate_sessionless_user!(:rss) | ○ |
| C-05 | パス未存在時はルートにリダイレクト | E-01: 73-78行目 validate_path メソッド | ○ |
| C-06 | 検索機能はfind_commits_by_messageを使用 | E-01: 101-102行目 search.present? 時の処理 | ○ |
| C-07 | 日付フィルタリング機能 | E-01: 94-95行目, 109-111行目 committed_before/after | ○ |
| C-08 | 作者フィルタリング機能 | E-01: 93, 109行目 author パラメータ処理 | ○ |
| C-09 | タグ情報のプリロード | E-01: 116行目 @commits.load_tags | ○ |
| C-10 | 作者情報の遅延読み込み | E-01: 117行目 @commits.each(&:lazy_author) | ○ |
| C-11 | パイプライン情報の取得 | E-01: 119行目 with_latest_pipeline(ref) | ○ |
| C-12 | Gitalyキャッシュの活用 | E-01: 13行目 around_action :allow_gitaly_ref_name_caching | ○ |
| C-13 | 署名情報のJSON取得 | E-01: 52-65行目 signatures アクション | ○ |
| C-14 | HTML/JSON/Atomの3形式対応 | E-01: 37-48行目 respond_to ブロック | ○ |
| C-15 | 無効な参照は404を返す | E-01: 69-71行目 validate_ref! メソッド | ○ |
| C-16 | MR検索機能 | E-01: 32-33行目 MergeRequestsFinder | ○ |
| C-17 | 関連画面はコミット一覧/詳細 | E-06: 40-41行目 画面No 40, 41 | ○ |
| C-18 | 1秒以内のレスポンス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「1秒以内」の数値根拠
  - 候補：SLA定義書 / パフォーマンステスト結果 / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 0: データベース操作仕様は適切
- 1: パフォーマンス要件は推定値のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] パフォーマンス要件「1秒以内」が妥当か確認
- [ ] Atomフィード出力のテンプレート存在確認
- [ ] 署名検証機能の詳細仕様確認
- [ ] フィーチャーフラグ require_login_for_commit_tree の有効化条件確認
