---
generated_at: 2026-01-22 12:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：22-差分表示（Diff）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **RapidDiffsプレゼンター**：新機能のため実装状況確認推奨
  2. **クロスプロジェクト比較**：権限チェックの詳細確認推奨
  3. **COMMITS_SAFE_SIZE制限**：閾値の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/compare_controller.rb` - 比較コントローラー実装
- E-02: `app/services/compare_service.rb` - 比較サービス実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3ドット比較がデフォルト | E-01: 148-149行目 straight パラメータ判定 | ○ |
| C-02 | 2ドット比較は straight=true | E-01: 69-70行目 redirect_to_with_two_dots | ○ |
| C-03 | 無効な参照はフラッシュエラーでリダイレクト | E-01: 105-112行目 validate_refs! メソッド | ○ |
| C-04 | from_project_id でクロスプロジェクト比較 | E-01: 115-131行目 target_project メソッド | ○ |
| C-05 | クロスプロジェクト時の権限チェック | E-01: 127行目 can?(current_user, :read_code, target_project) | ○ |
| C-06 | CompareService で差分計算 | E-01: 145行目, E-02: 15-21行目 | ○ |
| C-07 | COMMITS_SAFE_SIZE 制限 | E-01: 168行目 MergeRequestDiff::COMMITS_SAFE_SIZE | ○ |
| C-08 | HTML/Patch/Diff の3形式対応 | E-01: 33-53行目 respond_to ブロック | ○ |
| C-09 | send_git_patch でパッチ出力 | E-01: 46行目 send_git_patch メソッド | ○ |
| C-10 | send_git_diff で差分出力 | E-01: 51行目 send_git_diff メソッド | ○ |
| C-11 | MR検索機能 | E-01: 204-208行目 merge_request メソッド | ○ |
| C-12 | 環境情報取得 | E-01: 183-197行目 define_environment メソッド | ○ |
| C-13 | RapidDiffs プレゼンター使用 | E-01: 36-41行目 RapidDiffs::ComparePresenter | ○ |
| C-14 | diff_for_path 機能 | E-01: 56-60行目 diff_for_path アクション | ○ |
| C-15 | 署名情報取得 | E-01: 76-89行目 signatures アクション | ○ |
| C-16 | 関連画面は比較画面/結果 | E-04: 42-43行目 画面No 42, 43 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 0: データベース操作仕様は適切
- 0: セキュリティ考慮事項は実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] RapidDiffsプレゼンターの実装状況確認
- [ ] クロスプロジェクト比較時の権限チェックが網羅的か確認
- [ ] COMMITS_SAFE_SIZE の具体的な値確認
- [ ] Addressable::URI.unescape のセキュリティリスク確認
