---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-保護ブランチ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **グループレベル保護**：EE機能の可能性、詳細確認推奨
  2. **デプロイキー連携**：CI/CD自動化での利用確認推奨
  3. **キャッシュ更新**：CacheServiceの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/protected_branches_controller.rb` - 保護ブランチコントローラー
- E-02: `app/controllers/projects/protected_refs_controller.rb` - 保護参照基底コントローラー
- E-03: `app/models/protected_branch.rb` - 保護ブランチモデル
- E-04: `app/services/protected_branches/create_service.rb` - 作成サービス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | authorize_admin_project! による管理者権限確認 | E-02: 78-80行目 authorize_admin_protected_refs! | ○ |
| C-02 | ProtectedRefsController を継承 | E-01: 3行目 class継承 | ○ |
| C-03 | ref_type が :branches を返す | E-01: 12-14行目 ref_type メソッド | ○ |
| C-04 | CreateService による作成処理 | E-02: 62-64行目, E-04 | ○ |
| C-05 | UpdateService による更新処理 | E-02: 66-68行目 update_service_class | ○ |
| C-06 | DestroyService による削除処理 | E-02: 70-72行目 destroy_service_class | ○ |
| C-07 | show アクションでマッチングブランチ表示 | E-01: 4-8行目 show メソッド | ○ |
| C-08 | allow_force_push パラメータ | E-01: 34行目 :allow_force_push | ○ |
| C-09 | merge_access_levels_attributes | E-01: 35行目 | ○ |
| C-10 | push_access_levels_attributes | E-01: 36行目 | ○ |
| C-11 | プロジェクト内で名前一意 | E-03: 16行目 validates :name, uniqueness | ○ |
| C-12 | グループレベル保護対応 | E-03: 10行目 belongs_to :group | ○ |
| C-13 | キャッシュ更新処理 | E-04: 10行目 refresh_cache | ○ |
| C-14 | イベント発行 | E-04: 30-46行目 publish_created_event | ○ |
| C-15 | can?(:create_protected_branch) 権限チェック | E-04: 15-17行目 authorized? メソッド | ○ |
| C-16 | 空リポジトリでの保護 | E-03: 38-52行目 protected_ref_accessible_to? | ○ |
| C-17 | ワイルドカードマッチング | E-03: 55-61行目 protected?, matching メソッド | ○ |
| C-18 | 関連画面はリポジトリ設定/ブランチルール | E-06: 111, 119行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 0: データベース操作仕様は適切
- 1: グループレベル保護はEE機能の可能性（要確認）

## 6) レビュアーチェックリスト（最小）
- [ ] グループレベル保護ブランチのCE/EE機能確認
- [ ] CacheService の詳細実装確認
- [ ] デプロイキーによるプッシュ許可の動作確認
- [ ] ワイルドカードパターンマッチの仕様確認
