---
generated_at: 2026-01-22 13:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-保護タグ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. **タグ削除権限**：管理者のみ可能かの確認推奨
  2. **キャッシュ機構**：SafeRequestStore の詳細確認推奨
  3. **ワイルドカード**：パターンマッチの詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/protected_tags_controller.rb` - 保護タグコントローラー
- E-02: `app/controllers/projects/protected_refs_controller.rb` - 保護参照基底コントローラー
- E-03: `app/models/protected_tag.rb` - 保護タグモデル
- E-04: `app/services/protected_tags/create_service.rb` - 作成サービス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProtectedRefsController を継承 | E-01: 3行目 class継承 | ○ |
| C-02 | ref_type が :tags を返す | E-01: 6-8行目 ref_type メソッド | ○ |
| C-03 | project_refs でタグ取得 | E-01: 10-12行目 project_refs メソッド | ○ |
| C-04 | access_levels は create_access_levels のみ | E-01: 22-24行目 access_levels メソッド | ○ |
| C-05 | CreateService による作成処理 | E-04: 7-11行目 execute メソッド | ○ |
| C-06 | can?(:create_protected_tags) 権限チェック | E-04: 8行目 | ○ |
| C-07 | プロジェクト内で名前一意 | E-03: 7行目 validates :name, uniqueness | ○ |
| C-08 | プロジェクト必須 | E-03: 8行目 validates :project, presence | ○ |
| C-09 | SafeRequestStore によるキャッシュ | E-03: 14-21行目 protected? メソッド | ○ |
| C-10 | ワイルドカードマッチング | E-03: 21行目 self.matching メソッド | ○ |
| C-11 | preload_access_levels スコープ | E-03: 10行目 | ○ |
| C-12 | 関連画面はリポジトリ設定/タグ一覧 | E-06: 111, 37行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 0: データベース操作仕様は適切
- 0: セキュリティ考慮事項は実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] 既存タグの削除権限の確認
- [ ] SafeRequestStore のキャッシュ有効期間確認
- [ ] ワイルドカードパターンマッチの仕様確認
- [ ] UpdateService/DestroyService の実装確認
