---
generated_at: 2026-01-22 13:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-リポジトリミラーリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **プルミラー**：本設計書はプッシュミラーのみ、プルミラーはEE機能の可能性
  2. **認証情報暗号化**：attr_encrypted の詳細確認推奨
  3. **Sidekiqワーカー**：ジョブのリトライ設定確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/mirrors_controller.rb` - ミラーコントローラー
- E-02: `app/models/remote_mirror.rb` - リモートミラーモデル
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | authorize_admin_project! による管理者権限確認 | E-01: 9行目 | ○ |
| C-02 | check_mirror_available! による利用可能性確認 | E-01: 8, 122-124行目 | ○ |
| C-03 | show でリポジトリ設定にリダイレクト | E-01: 15-17行目 | ○ |
| C-04 | update で作成/削除処理 | E-01: 19-49行目 | ○ |
| C-05 | update_now で手動同期 | E-01: 51-58行目 | ○ |
| C-06 | ssh_host_keys でホストキー取得 | E-01: 60-74行目 | ○ |
| C-07 | state_machine による状態遷移 | E-02: 41-84行目 | ○ |
| C-08 | バックオフ遅延（保護:1分、全体:5分） | E-02: 11-12行目 PROTECTED/UNPROTECTED_BACKOFF_DELAY | ○ |
| C-09 | 最大実行時間（初回:3時間、増分:1時間） | E-02: 9-10行目 MAX_FIRST/INCREMENTAL_RUNTIME | ○ |
| C-10 | 認証情報の暗号化 | E-02: 14-20行目 attr_encrypted | ○ |
| C-11 | サイレントモード時は無効 | E-02: 143行目 Gitlab::SilentMode.enabled? | ○ |
| C-12 | pending_delete 時は無効 | E-02: 142行目 project.pending_delete? | ○ |
| C-13 | リポジトリ未存在時は無効 | E-02: 141行目 project.repository_exists? | ○ |
| C-14 | only_protected_branches オプション | E-02: 107-109行目 | ○ |
| C-15 | keep_divergent_refs オプション | E-02: 104行目 | ○ |
| C-16 | 関連画面はリポジトリ設定 | E-04: 111行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 1: プルミラー機能はEE機能の可能性（本設計書はプッシュのみ対象）
- 0: セキュリティ考慮事項は実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] プルミラー機能の有無・CE/EE区分確認
- [ ] attr_encrypted による暗号化の詳細確認
- [ ] Sidekiqワーカーのリトライ設定確認
- [ ] SSHホストキー検証の動作確認
