---
generated_at: 2026-01-22 13:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-マージリクエスト作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **preparing状態**：差分計算完了後の状態遷移確認推奨
  2. **スパムチェック**：Spammable concern の詳細確認推奨
  3. **NewMergeRequestWorker**：非同期処理の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/controllers/projects/merge_requests_controller.rb` - MRコントローラー
- E-02: `app/services/merge_requests/create_service.rb` - 作成サービス
- E-03: `app/models/merge_request.rb` - MRモデル
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | index アクションで一覧表示 | E-01: 97-104行目 | ○ |
| C-02 | set_projects! でソース/ターゲット設定 | E-02: 55-73行目 | ○ |
| C-03 | create_merge_request_from 権限チェック | E-02: 68-72行目 | ○ |
| C-04 | create_merge_request_in 権限チェック | E-02: 68-72行目 | ○ |
| C-05 | set_default_attributes! でデフォルト設定 | E-02: 75-81行目 | ○ |
| C-06 | スカッシュデフォルト適用 | E-02: 79-81行目 squash_enabled_by_default? | ○ |
| C-07 | before_create でスパムチェック | E-02: 45-53行目 check_for_spam | ○ |
| C-08 | after_create で Worker 起動 | E-02: 23-36行目 NewMergeRequestWorker | ○ |
| C-09 | mark_as_preparing で状態遷移 | E-02: 34行目 | ○ |
| C-10 | skip_ensure_merge_request_diff | E-02: 51行目 | ○ |
| C-11 | state_machine による状態管理 | E-03: 210-254行目 | ○ |
| C-12 | merge_status の状態遷移 | E-03: 256-298行目 | ○ |
| C-13 | iid自動採番 | E-03: 62-69行目 has_internal_id | ○ |
| C-14 | Draft状態判定 | E-03: 170行目 before_validation :set_draft_status | ○ |
| C-15 | 関連画面はMR一覧/新規作成 | E-05: 61-62行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 0: データベース操作仕様は適切
- 0: セキュリティ考慮事項は実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] preparing 状態から can_be_merged への遷移確認
- [ ] NewMergeRequestWorker の処理内容確認
- [ ] スパムチェックの判定基準確認
- [ ] MRテンプレート適用の動作確認
