---
generated_at: 2026-01-22 13:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：29-マージリクエスト編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **専用サービス**：UpdateAssigneesService等の詳細確認推奨
  2. **クイックアクション**：/rebase, /merge の動作確認推奨
  3. **Draft状態変更**：イベント発行の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/merge_requests/update_service.rb` - 更新サービス
- E-02: `app/controllers/projects/merge_requests_controller.rb` - MRコントローラー
- E-03: `app/models/merge_request.rb` - MRモデル
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | execute で更新処理のメインロジック | E-01: 13-24行目 | ○ |
| C-02 | draft: true でタイトルにDraft:付与 | E-01: 14-16行目 merge_request.draft_title | ○ |
| C-03 | merge_after でUpdateMergeScheduleService | E-01: 18-21行目 | ○ |
| C-04 | 専用サービスへの振り分け | E-01: 326-338行目 update_merge_request_with_specialized_service | ○ |
| C-05 | assignee_ids でUpdateAssigneesService | E-01: 340-347行目 attempt_specialized_update_services | ○ |
| C-06 | source_project/branch の変更不可 | E-01: 117-120行目 params.delete | ○ |
| C-07 | closed_or_merged_without_fork後の制限 | E-01: 122-125行目 | ○ |
| C-08 | handle_changes での変更後処理 | E-01: 26-63行目 | ○ |
| C-09 | target_branch変更時のパイプライン/auto_merge処理 | E-01: 212-238行目 handle_target_branch_change | ○ |
| C-10 | Draft状態変更時の通知・イベント | E-01: 240-277行目 handle_draft_status_change | ○ |
| C-11 | before_update でスパムチェック | E-01: 285-288行目 check_for_spam | ○ |
| C-12 | クイックアクション /rebase で rebase_async | E-01: 306-308行目 | ○ |
| C-13 | クイックアクション /merge で MergeOrchestrationService | E-01: 310-316行目 | ○ |
| C-14 | ラベル追加時の通知 | E-01: 182-192行目 notify_if_labels_added | ○ |
| C-15 | メンション追加時の通知 | E-01: 194-204行目 notify_if_mentions_added | ○ |
| C-16 | TODO解決の非同期処理 | E-01: 382-388行目 ResolveTodosService.async_execute | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 0: データベース操作仕様は適切
- 0: セキュリティ考慮事項は実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] UpdateAssigneesService の権限チェック確認
- [ ] /rebase クイックアクションの競合回避確認
- [ ] Draft状態変更イベントの購読者確認
- [ ] target_branch変更時の承認リセット動作確認（EE機能）
