---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-プロジェクト削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects_controller.rb` - destroyアクション（201-221行目）
- E-02: `app/services/projects/destroy_service.rb` - DestroyServiceクラス全体
- E-03: `app/services/projects/destroy_service.rb` - async_execute（11-16行目）
- E-04: `app/services/projects/destroy_service.rb` - execute（18-68行目）
- E-05: `app/services/projects/destroy_service.rb` - validate_active_repositories_move!（95-103行目）
- E-06: `app/services/projects/destroy_service.rb` - attempt_destroy（179-186行目）
- E-07: `app/services/projects/destroy_service.rb` - destroy_project_related_records（192-220行目）
- E-08: `app/services/projects/destroy_service.rb` - remove_registry_tags（400-411行目）
- E-09: `app/services/projects/destroy_service.rb` - destroy_ci_records!（286-308行目）
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.3の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | destroyアクションで権限チェックが行われる | E-01 (202行目) | ○ |
| C-02 | 即時削除と通常削除の分岐がある | E-01 (204-212行目) | ○ |
| C-03 | 即時削除は管理者許可が必要 | E-01 (207行目) | ○ |
| C-04 | 非同期実行でProjectDestroyWorkerが使用される | E-03 (14行目) | ○ |
| C-05 | 削除前にストレージ移動チェックがある | E-05 | ○ |
| C-06 | スニペットストレージ移動もチェックされる | E-05 (100-102行目) | ○ |
| C-07 | キャッシュがフラッシュされる | E-04 (37行目) | ○ |
| C-08 | CIパイプラインが中止される | E-04 (39行目) | ○ |
| C-09 | フォーク関係が解除される | E-04 (41行目) | ○ |
| C-10 | コンテナレジストリタグが削除される | E-08 | ○ |
| C-11 | プールリポジトリから離脱する | E-06 (184行目) | ○ |
| C-12 | スニペットが削除される | E-07 (194行目), E-02 (125-135行目) | ○ |
| C-13 | リポジトリが削除される（メイン、Wiki、デザイン） | E-07 (195行目), E-02 (105-117行目) | ○ |
| C-14 | イベントが削除される | E-07 (196行目), E-02 (137-153行目) | ○ |
| C-15 | Webhookが削除される | E-07 (197行目), E-02 (368-376行目) | ○ |
| C-16 | プロジェクトボットが削除される | E-07 (198行目), E-02 (380-389行目) | ○ |
| C-17 | CIレコードがバッチ削除される | E-09 | ○ |
| C-18 | デプロイメントが削除される | E-07 (200行目), E-02 (345-349行目) | ○ |
| C-19 | MR Diffが削除される | E-07 (201行目), E-02 (232-267行目) | ○ |
| C-20 | システムフックが実行される | E-02 (188-190行目) | ○ |
| C-21 | 削除イベントが発行される | E-04 (54行目), E-02 (438-446行目) | ○ |
| C-22 | 失敗時にロールバックとエラー記録が行われる | E-02 (163-177行目) | ○ |
| C-23 | バッチサイズは100件 | E-02 (9行目) | ○ |
| C-24 | 機能No.3がプロジェクト削除機能 | E-10 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] エラーケース一覧がコード上のエラーハンドリングと一致しているか確認
- [ ] 削除対象リソースの網羅性を確認（新規追加されたリソースがないか）
- [ ] Container Registry保護ルールの処理が最新仕様と一致しているか確認
