---
generated_at: 2026-01-22 13:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-マージリクエストマージ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **マージ戦略**：FromSourceBranch以外の戦略確認推奨
  2. **EEエラーチェック**：error_check! のEE拡張確認推奨
  3. **Issue自動クローズ**：バッチ処理の詳細確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/services/merge_requests/merge_service.rb` - マージサービス
- E-02: `app/services/merge_requests/merge_base_service.rb` - マージ基底サービス
- E-03: `app/services/merge_requests/post_merge_service.rb` - 後処理サービス
- E-04: `app/models/merge_request.rb` - MRモデル
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | execute でマージ処理のメインロジック | E-01: 17-42行目 | ○ |
| C-02 | exclusive_lease による排他制御 | E-01: 19行目 try_obtain, 41行目 cancel | ○ |
| C-03 | merge_strategy でマージ戦略選択 | E-01: 21-22行目 merge_strategy_class | ○ |
| C-04 | validate! で全バリデーション | E-01: 46-51行目 | ○ |
| C-05 | authorization_check! で権限確認 | E-01: 53-57行目 can_be_merged_by? | ○ |
| C-06 | updated_check! でSHA一致確認 | E-01: 63-68行目 source_matches? | ○ |
| C-07 | in_locked_state でロック状態 | E-01: 30行目 | ○ |
| C-08 | commit でGitマージ実行 | E-01: 70-91行目 execute_git_merge! | ○ |
| C-09 | merged_commit_sha等の更新 | E-01: 80-85行目 new_merge_request_attributes | ○ |
| C-10 | after_merge で後処理呼び出し | E-01: 102-117行目 | ○ |
| C-11 | PostMergeService での後処理 | E-01: 108-109行目, E-03: 15-50行目 | ○ |
| C-12 | mark_as_merged でMR状態更新 | E-03: 20-29行目 | ○ |
| C-13 | close_issues で関連Issue自動クローズ | E-03: 64-79行目 | ○ |
| C-14 | delete_source_branch? 判定ロジック | E-01: 126-129行目 | ○ |
| C-15 | DeleteSourceBranchWorker で非同期削除 | E-01: 113行目 | ○ |
| C-16 | GENERIC_ERROR_MESSAGE 定数 | E-01: 13行目 'An error occurred while merging' | ○ |
| C-17 | MergeError でエラーハンドリング | E-01: 38-39行目, E-02: 7行目 | ○ |
| C-18 | source_matches? でSHA比較 | E-01: 168-172行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 処理フローは実装に忠実
- 1: EE機能（error_check!、hooks_validation_pass?）の詳細は本設計書外
- 0: セキュリティ考慮事項は実装通り

## 6) レビュアーチェックリスト（最小）
- [ ] EE拡張のerror_check! 内容確認
- [ ] マージ戦略（FromSourceBranch以外）の確認
- [ ] Issue自動クローズのバッチサイズ・遅延設定確認
- [ ] pre-receiveフックの挙動確認
- [ ] 排他ロックのタイムアウト設定確認
