---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：31-コードレビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **最大長制限**：noteパラメータの具体的な最大長の根拠不足
  2. **ドラフト公開制限**：作成者のみが公開可能というルールの実装箇所未特定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/controllers/projects/merge_requests/drafts_controller.rb`
- E-02: `app/controllers/projects/merge_requests/diffs_controller.rb`
- E-03: `app/services/merge_requests/update_reviewer_state_service.rb`
- E-04: `app/services/merge_requests/approval_service.rb`
- E-05: `app/services/merge_requests/update_reviewers_service.rb`
- E-06: `app/models/merge_request.rb` (先頭500行)
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コードレビュー機能はマージリクエストの差分に対するコメント・レビュー機能 | E-08 (31行目) | ○ |
| C-02 | DraftsControllerでドラフトノートのCRUD操作を行う | E-01 (全体) | ○ |
| C-03 | createアクションでDraftNotes::CreateServiceを呼び出す | E-01 (30行目) | ○ |
| C-04 | publishアクションでドラフトを一括公開する | E-01 (59-76行目) | ○ |
| C-05 | authorize_create_note!によるノート作成権限チェック | E-01 (8行目) | ○ |
| C-06 | authorize_admin_draft!によるドラフト管理権限チェック | E-01 (9-10行目) | ○ |
| C-07 | UpdateReviewerStateServiceでレビュー状態を更新する | E-03 (全体) | ○ |
| C-08 | 変更要求時に承認が取り消される | E-03 (25-27行目) | ○ |
| C-09 | ApprovalServiceで承認を記録する | E-04 (全体) | ○ |
| C-10 | マージ済みMRには新規承認不可 | E-04 (7行目) | ○ |
| C-11 | 承認処理でイベントを発行する | E-04 (30-35行目) | ○ |
| C-12 | DiffsControllerで差分表示を行う | E-02 (全体) | ○ |
| C-13 | urgency :low指定で低優先度 | E-02 (18-23行目), E-01 (12-17行目) | ○ |
| C-14 | ETagによるキャッシュ制御 | E-02 (86行目) | ○ |
| C-15 | 1日のキャッシュ有効期限 | E-02 (84行目) | ○ |
| C-16 | 関連画面として画面No.63 MR詳細が存在する | E-07 (96行目) | ○ |
| C-17 | update_reviewer_stateで状態をreviewedに更新可能 | E-03 (12行目) | ○ |
| C-18 | update_reviewer_stateで状態をapprovedに更新可能 | E-03 (11行目) | ○ |
| C-19 | update_reviewer_stateで状態をrequested_changesに更新可能 | E-03 (10行目) | ○ |
| C-20 | SystemNoteService.requested_changesでシステムノート作成 | E-03 (40行目) | ○ |
| C-21 | reviewer.update(state: state)でDB更新 | E-03 (16行目) | ○ |
| C-22 | 入力パラメータにnote, position, commit_id等がある | E-01 (111-125行目) | ○ |
| C-23 | internalフラグで内部コメント制御 | E-01 (118行目) | ○ |
| C-24 | noteパラメータの最大長制限がある | **根拠なし** | △ |
| C-25 | ドラフトノートは作成者のみが公開可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-24: noteパラメータの最大長制限について、コントローラーやモデル内にバリデーションの明示的な記載が見つからなかった
  - 候補：`app/models/draft_note.rb` / `app/models/note.rb` / データベーススキーマ
- C-25: 作成者のみが公開可能というビジネスルールの実装箇所が明確に特定できなかった
  - 候補：`app/services/draft_notes/publish_service.rb` / ポリシークラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張に根拠あり
- 1: 中リスク - 一部のビジネスルール（C-24, C-25）について実装確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] noteパラメータの最大長制限が実装されているか確認（C-24）
- [ ] ドラフト公開時の作成者チェックロジックを確認（C-25）
- [ ] UpdateReviewerStateServiceの状態遷移ルールが網羅されているか確認
- [ ] 承認処理のトランザクション範囲が適切か確認
