---
generated_at: 2026-01-22 12:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：32-マージコンフリクト解決

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **バイナリファイル制限**：バイナリファイルのUI解決不可の実装確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/merge_requests/conflicts_controller.rb`
- E-02: `app/services/merge_requests/conflicts/list_service.rb`
- E-03: `app/services/merge_requests/conflicts/resolve_service.rb`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マージコンフリクト解決機能はコンフリクトの検出とWeb UI上での解決を提供 | E-05 (32行目) | ○ |
| C-02 | ConflictsControllerでコンフリクト処理を行う | E-01 (全体) | ○ |
| C-03 | showアクションでコンフリクト一覧表示 | E-01 (14-39行目) | ○ |
| C-04 | resolve_conflictsアクションで解決処理 | E-01 (52-74行目) | ○ |
| C-05 | ListService#can_be_resolved_in_ui?でUI解決可否判定 | E-02 (15-27行目) | ○ |
| C-06 | cannot_be_merged?チェックがUI解決可否判定に含まれる | E-02 (22行目) | ○ |
| C-07 | has_complete_diff_refs?チェックがUI解決可否判定に含まれる | E-02 (23行目) | ○ |
| C-08 | branch_missing?チェックがUI解決可否判定に含まれる | E-02 (24行目) | ○ |
| C-09 | can_be_resolved_by?でソースブランチプッシュ権限チェック | E-02 (8-13行目) | ○ |
| C-10 | UserAccessクラスで権限検証 | E-02 (11行目) | ○ |
| C-11 | ResolveService#executeで解決処理実行 | E-03 (6-10行目) | ○ |
| C-12 | Gitlab::Conflict::FileCollectionを使用 | E-03 (7行目), E-02 (30-36行目) | ○ |
| C-13 | 既にマージ可能な場合はエラー | E-01 (57-61行目) | ○ |
| C-14 | ResolutionError発生時はbad_requestで返す | E-01 (71-72行目) | ○ |
| C-15 | 解決完了時はフラッシュメッセージ表示 | E-01 (68行目) | ○ |
| C-16 | 解決完了時はMR詳細画面にリダイレクト | E-01 (70行目) | ○ |
| C-17 | urgency :low指定 | E-01 (8-12行目) | ○ |
| C-18 | authorize_can_resolve_conflicts!で権限チェック | E-01 (80-83行目) | ○ |
| C-19 | 関連画面として画面No.65コンフリクト解決が存在 | E-04 (100行目) | ○ |
| C-20 | バイナリファイルのコンフリクトはUI解決不可 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: バイナリファイルのUI解決不可について、FileCollectionクラス内のチェックロジックの詳細確認が必要
  - 候補：`lib/gitlab/conflict/file_collection.rb` / `lib/gitlab/conflict/file.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大半の主張に根拠あり、コア機能は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] バイナリファイルのコンフリクト処理を確認（C-20）
- [ ] ツリーコンフリクトの処理を確認
- [ ] Gitalyとの連携エラー時の処理を確認
