---
generated_at: 2026-01-22 12:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：33-自動マージ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **AutoMergeProcessWorker**：ワーカーファイルの詳細確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/auto_merge_service.rb`
- E-02: `app/services/auto_merge/merge_when_checks_pass_service.rb`
- E-03: `app/models/merge_request.rb` (先頭500行)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 自動マージ機能はCI/CD成功後の自動マージ設定を提供 | E-05 (33行目) | ○ |
| C-02 | STRATEGY_MERGE_WHEN_CHECKS_PASSが定義されている | E-01 (6行目) | ○ |
| C-03 | executeメソッドで自動マージを有効化 | E-01 (29-36行目) | ○ |
| C-04 | processメソッドで条件チェックとマージ実行 | E-01 (46-51行目) | ○ |
| C-05 | cancelメソッドで自動マージをキャンセル | E-01 (54-59行目) | ○ |
| C-06 | abortメソッドで自動マージを中止 | E-01 (62-68行目) | ○ |
| C-07 | preferred_strategyで優先戦略を取得 | E-01 (76-78行目) | ○ |
| C-08 | available_strategiesで利用可能な戦略を取得 | E-01 (70-74行目) | ○ |
| C-09 | MergeWhenChecksPassServiceでMWCP戦略を実装 | E-02 (全体) | ○ |
| C-10 | processでCIパイプライン成功をチェック | E-02 (19行目) | ○ |
| C-11 | processでmergeableをチェック | E-02 (23行目) | ○ |
| C-12 | merge_asyncでマージを非同期実行 | E-02 (27行目) | ○ |
| C-13 | SystemNoteService.merge_when_checks_passでシステムノート | E-02 (63-68行目) | ○ |
| C-14 | SystemNoteService.cancel_auto_mergeでキャンセルノート | E-02 (33行目) | ○ |
| C-15 | SystemNoteService.abort_auto_mergeで中止ノート | E-02 (40行目) | ○ |
| C-16 | マージトレイン有効時は自動マージ利用不可 | E-02 (50行目) | ○ |
| C-17 | mergeableかつパイプライン進行中でない場合は利用不可 | E-02 (52行目) | ○ |
| C-18 | キャンセル時に自動マージ未設定ならエラー | E-01 (55行目) | ○ |
| C-19 | 中止時に自動マージ未設定ならエラー | E-01 (63行目) | ○ |
| C-20 | merge_statusの状態変更でAutoMergeProcessWorkerをトリガー | E-03 (300-306行目) | ○ |
| C-21 | Feature flag auto_merge_on_merge_status_changeで制御 | E-03 (300行目) | ○ |
| C-22 | AutoMergeProcessWorkerの詳細な実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: AutoMergeProcessWorkerの実装詳細について、ワーカーファイルの確認が必要
  - 候補：`app/workers/auto_merge_process_worker.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローは実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AutoMergeProcessWorkerの実装を確認（C-22）
- [ ] EE版のmerge_train戦略との関係を確認
- [ ] merge_paramsのシリアライズ形式を確認
