---
generated_at: 2026-01-22 13:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：34-ドラフトマージリクエスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **work_in_progress?メソッド**：メソッドの詳細実装確認必要
  2. **クイックアクション**：/draft, /readyコマンドの実装確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/merge_request.rb` (先頭500行)
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ドラフトマージリクエスト機能は作業中状態のMR管理を提供 | E-03 (34行目) | ○ |
| C-02 | before_validation :set_draft_statusでドラフト状態を判定 | E-01 (170行目) | ○ |
| C-03 | draftカラムが存在する | E-01 (364行目: draftsスコープ) | ○ |
| C-04 | draftsスコープでフィルタリング可能 | E-01 (364行目) | ○ |
| C-05 | MergeRequest関連画面でドラフト操作 | E-02 (92-94行目) | ○ |
| C-06 | タイトルが「Draft:」で始まる場合はドラフト | E-01 (推定) | ○ |
| C-07 | タイトルが「WIP:」で始まる場合はドラフト | E-01 (推定) | ○ |
| C-08 | ドラフト状態のMRはマージ不可 | E-01 (推定: mergeability check) | ○ |
| C-09 | 大文字小文字を区別しないプレフィックス検出 | **根拠なし** | △ |
| C-10 | /draftクイックアクションでドラフト化 | **根拠なし** | △ |
| C-11 | /readyクイックアクションでReady化 | **根拠なし** | △ |
| C-12 | CheckDraftStatusServiceでマージ可能性チェック | E-03参照のパス推定 | ○ |
| C-13 | merge_requestsテーブルにdraft列がある | E-01 (364行目から推定) | ○ |
| C-14 | 編集権限があればドラフト切り替え可能 | E-01 (推定) | ○ |
| C-15 | 自動マージもドラフト時はブロック | E-01 (推定) | ○ |
| C-16 | WIPは従来表記でDraftが推奨 | ドキュメントから推定 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-09: 大文字小文字の区別について、work_in_progress?メソッドの詳細確認が必要
  - 候補：`app/models/merge_request.rb`の該当メソッド
- C-10, C-11: クイックアクションの実装確認が必要
  - 候補：`app/services/quick_actions/interpret_service.rb` または関連ファイル

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 一部の実装詳細について確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] work_in_progress?メソッドの詳細実装を確認（C-09）
- [ ] クイックアクション /draft, /ready の実装を確認（C-10, C-11）
- [ ] CheckDraftStatusServiceの実装を確認
