---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：35-レビュアー・承認者管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **レビュアー上限**：具体的な上限値の設定箇所確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/merge_request.rb` (先頭500行)
- E-02: `app/services/merge_requests/update_reviewers_service.rb`
- E-03: `app/services/merge_requests/update_reviewer_state_service.rb`
- E-04: `app/services/merge_requests/approval_service.rb`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | レビュアー・承認者管理機能はMRのレビュアーと承認者の設定・管理を提供 | E-06 (35行目) | ○ |
| C-02 | has_many :reviewersでレビュアー関連を定義 | E-01 (141-142行目) | ○ |
| C-03 | has_many :approvalsで承認関連を定義 | E-01 (推定) | ○ |
| C-04 | UpdateReviewersServiceでレビュアー更新 | E-02 (全体) | ○ |
| C-05 | set_merge_request_metadata権限チェック | E-02 (6行目) | ○ |
| C-06 | handle_reviewers_changeでレビュアー変更処理 | E-02 (18行目) | ○ |
| C-07 | execute_reviewers_hooksでWebhook実行 | E-02 (20行目) | ○ |
| C-08 | UpdateReviewerStateServiceで状態更新 | E-03 (全体) | ○ |
| C-09 | 変更要求時に承認が取り消される | E-03 (25-27行目) | ○ |
| C-10 | create_requested_changesで変更要求記録 | E-03 (37-42行目) | ○ |
| C-11 | SystemNoteService.requested_changesでシステムノート | E-03 (40行目) | ○ |
| C-12 | ApprovalServiceで承認処理 | E-04 (全体) | ○ |
| C-13 | マージ済みMRには承認不可 | E-04 (7行目) | ○ |
| C-14 | eligible_for_approval?で承認資格チェック | E-04 (42-44行目) | ○ |
| C-15 | 承認時にpatch_id_shaを記録 | E-04 (11行目) | ○ |
| C-16 | Gitlab::EventStore.publishでイベント発行 | E-04 (30-35行目) | ○ |
| C-17 | update_reviewer_stateで状態をapprovedに | E-04 (16行目) | ○ |
| C-18 | 関連画面として画面No.63 MR詳細が存在 | E-05 (98行目) | ○ |
| C-19 | reviewer_state に reviewed, approved, requested_changes が存在 | E-03 (10-12行目) | ○ |
| C-20 | レビュアー数には上限がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: レビュアー上限の設定について、バリデーションまたは設定ファイルの確認が必要
  - 候補：`app/models/merge_request.rb`のバリデーション / プロジェクト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] レビュアー上限の実装を確認（C-20）
- [ ] セルフ承認の制御ロジックを確認
- [ ] EE版の必須承認ルールとの関連を確認
