---
generated_at: 2026-01-22 13:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：36-イシュー作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **レート制限の詳細**：具体的な制限値の確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/issues_controller.rb`
- E-02: `app/services/issues/create_service.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イシュー作成機能はバグ報告、機能要望、タスクなどのイシュー作成を提供 | E-04 (36行目) | ○ |
| C-02 | newアクションでBuildServiceを使用 | E-01 (118行目) | ○ |
| C-03 | createアクションでCreateServiceを使用 | E-01 (174行目) | ○ |
| C-04 | authorize_create_issue!で権限チェック | E-01 (44行目) | ○ |
| C-05 | レート制限が設定されている | E-02 (9-10行目) | ○ |
| C-06 | スパムチェックを実行 | E-02 (51行目) | ○ |
| C-07 | 権限なしで403エラー | E-02 (21行目) | ○ |
| C-08 | NewIssueWorkerで非同期通知 | E-02 (173行目) | ○ |
| C-09 | PlacementWorkerで位置決め | E-02 (174行目) | ○ |
| C-10 | ディスカッション解決機能 | E-02 (97-106行目) | ○ |
| C-11 | Gitlab::EventStore.publishでイベント発行 | E-02 (70-78行目) | ○ |
| C-12 | デフォルトテンプレートの適用 | E-02 (142-168行目) | ○ |
| C-13 | urgency :low指定 | E-01 (75-80行目) | ○ |
| C-14 | 関連画面として画面No.48が存在 | E-03 (73行目) | ○ |
| C-15 | issue_typeパラメータの処理 | E-02 (30行目) | ○ |
| C-16 | handle_move_between_idsの処理 | E-02 (32行目) | ○ |
| C-17 | add_related_issueの処理 | E-02 (34行目) | ○ |
| C-18 | before_createでスパムチェック | E-02 (50-54行目) | ○ |
| C-19 | after_createで各種後処理 | E-02 (58-68行目) | ○ |
| C-20 | WorkItemCreatedEventを発行 | E-02 (70-78行目) | ○ |
| C-21 | 担当者変更のハンドリング | E-02 (89-95行目) | ○ |
| C-22 | 具体的なレート制限値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-22: レート制限の具体的な値（回数、期間）についてはrate_limiterの設定確認が必要
  - 候補：`config/initializers/rack_attack.rb` または関連設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] レート制限の具体的な設定値を確認（C-22）
- [ ] BuildServiceの詳細実装を確認
- [ ] WorkItem移行の影響範囲を確認
