---
generated_at: 2026-01-22 13:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：37-イシュー編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **楽観的ロック**：lock_versionの具体的な実装確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/issues/update_service.rb`
- E-02: `app/controllers/projects/issues_controller.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イシュー編集機能は既存イシューの編集を提供 | E-04 (37行目) | ○ |
| C-02 | UpdateServiceでイシュー更新 | E-01 (全体) | ○ |
| C-03 | executeメソッドで更新実行 | E-01 (17-21行目) | ○ |
| C-04 | handle_move_between_idsの処理 | E-01 (18行目) | ○ |
| C-05 | change_issue_duplicateの処理 | E-01 (20行目) | ○ |
| C-06 | move_issue_to_new_containerの処理 | E-01 (21行目) | ○ |
| C-07 | before_updateでスパムチェック | E-01 (30-36行目) | ○ |
| C-08 | change_work_item_typeでタイプ変更 | E-01 (38-46行目) | ○ |
| C-09 | handle_changesで各種変更処理 | E-01 (48-73行目) | ○ |
| C-10 | handle_assignee_changesで担当者変更 | E-01 (75-86行目) | ○ |
| C-11 | 担当者変更時に通知送信 | E-01 (80行目) | ○ |
| C-12 | 担当者変更時にTodo更新 | E-01 (81行目) | ○ |
| C-13 | handle_confidential_changeで機密変更 | E-01 (211-218行目) | ○ |
| C-14 | handle_added_labelsでラベル通知 | E-01 (220-226行目) | ○ |
| C-15 | GraphqlTriggers.work_item_updated呼び出し | E-01 (162行目) | ○ |
| C-16 | WorkItemUpdatedEvent発行 | E-01 (166-178行目) | ○ |
| C-17 | sync_to_work_item_descriptionで同期 | E-01 (138-156行目) | ○ |
| C-18 | 関連画面として画面No.49が存在 | E-03 (75行目) | ○ |
| C-19 | authorize_update_issuable!で権限チェック | E-02 (47行目) | ○ |
| C-20 | lock_versionによる楽観的ロック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20: lock_versionの実装について、モデルでの定義確認が必要
  - 候補：`app/models/issue.rb` / `db/schema.rb`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] lock_versionの楽観的ロック実装を確認（C-20）
- [ ] WorkItem同期の詳細を確認
- [ ] 各handle_*メソッドの網羅性を確認
