---
generated_at: 2026-01-22 13:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-イシュークローズ/再オープン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `app/services/issues/close_service.rb`
- E-02: `app/services/issues/reopen_service.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イシュークローズ/再オープン機能はイシューの完了状態の管理を提供 | E-04 (38行目) | ○ |
| C-02 | CloseServiceでクローズ処理 | E-01 (全体) | ○ |
| C-03 | ReopenServiceで再オープン処理 | E-02 (全体) | ○ |
| C-04 | can_close?で権限チェック | E-01 (89-91行目) | ○ |
| C-05 | can_reopen?で権限チェック | E-02 (42-44行目) | ○ |
| C-06 | issue.closeでクローズ | E-01 (50行目) | ○ |
| C-07 | issue.reopenで再オープン | E-02 (38-40行目) | ○ |
| C-08 | EventService.close_issueでイベント記録 | E-01 (55行目) | ○ |
| C-09 | EventService.reopen_issueでイベント記録 | E-02 (17行目) | ○ |
| C-10 | SystemNoteService.change_statusでノート作成 | E-01 (106行目) | ○ |
| C-11 | NotificationService.close_issueで通知 | E-01 (67-69行目) | ○ |
| C-12 | NotificationService.reopen_issueで通知 | E-02 (26行目) | ○ |
| C-13 | TodoService.close_issueでTodo更新 | E-01 (72行目) | ○ |
| C-14 | execute_hooksでWebhook実行 | E-01 (74行目), E-02 (28行目) | ○ |
| C-15 | インシデント時はアラート解決 | E-01 (93-96行目, 109-128行目) | ○ |
| C-16 | インシデント時はタイムラインイベント | E-01 (138行目) | ○ |
| C-17 | invalidate_cache_countsでキャッシュ更新 | E-01 (75行目) | ○ |
| C-18 | マイルストーンの完了数キャッシュ削除 | E-01 (81行目) | ○ |
| C-19 | 関連画面として画面No.49が存在 | E-03 (76行目) | ○ |
| C-20 | 外部イシュートラッカー連携 | E-01 (98-103行目) | ○ |
| C-21 | GraphqlTriggers.work_item_updated呼び出し | E-01 (84行目), E-02 (33行目) | ○ |
| C-22 | track_incident_actionでトラッキング | E-01 (77行目), E-02 (32行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 外部イシュートラッカー連携の動作確認
- [ ] インシデント連動処理の網羅性確認
- [ ] MRマージによる自動クローズのリンク確認
