---
generated_at: 2026-01-22 13:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：39-イシューボード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **MoveIssueService**：イシュー移動サービスの詳細確認必要
  2. **GraphQL API**：リアルタイム更新の実装確認必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects/boards_controller.rb`
- E-02: `app/services/boards/create_service.rb`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | イシューボード機能はカンバン形式でイシューを視覚的に管理 | E-04 (39行目) | ○ |
| C-02 | BoardsControllerでボード操作 | E-01 (全体) | ○ |
| C-03 | BoardsFinder使用 | E-01 (20-22行目) | ○ |
| C-04 | CreateServiceでボード作成 | E-02 (全体) | ○ |
| C-05 | authorize_read_board!で権限チェック | E-01 (32-33行目) | ○ |
| C-06 | can_create_board?でボード作成可否判定 | E-02 (15-17行目) | ○ |
| C-07 | バックログリスト自動作成 | E-02 (27行目) | ○ |
| C-08 | クローズリスト自動作成 | E-02 (28行目) | ○ |
| C-09 | 複数ボードの可用性チェック | E-02 (16行目) | ○ |
| C-10 | 関連画面として画面No.50, 51が存在 | E-03 (79-80行目) | ○ |
| C-11 | グループボード画面No.152, 153が存在 | E-03 (209-210行目) | ○ |
| C-12 | urgency :low指定 | E-01 (16行目) | ○ |
| C-13 | BoardsActions concernを使用 | E-01 (4行目) | ○ |
| C-14 | check_issues_available!でイシュー機能チェック | E-01 (7行目) | ○ |
| C-15 | feature_category :team_planning | E-01 (15行目) | ○ |
| C-16 | ServiceResponse使用 | E-02 (7, 23, 31行目) | ○ |
| C-17 | Lists::MoveIssueServiceでイシュー移動 | **根拠なし** | △ |
| C-18 | GraphQL APIでリアルタイム更新 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-17: MoveIssueServiceの実装確認が必要
  - 候補：`app/services/boards/lists/move_issue_service.rb` または類似
- C-18: GraphQL APIのリアルタイム更新実装確認が必要
  - 候補：`app/graphql/subscriptions/` 配下

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 一部の機能詳細について確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] MoveIssueServiceの実装を確認（C-17）
- [ ] GraphQL subscriptionの実装を確認（C-18）
- [ ] EE版の追加機能（担当者リスト等）を確認
