---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-プロジェクトアーカイブ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects_controller.rb` - archiveアクション（248-254行目）
- E-02: `app/controllers/projects_controller.rb` - unarchiveアクション（256-262行目）
- E-03: `app/services/projects/archive_service.rb` - ArchiveServiceクラス全体
- E-04: `app/services/projects/archive_service.rb` - executeメソッド（23-37行目）
- E-05: `app/services/projects/archive_service.rb` - archive_project（42-45行目）
- E-06: `app/services/projects/archive_service.rb` - after_archive（48-53行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.4の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | archiveアクションがArchiveServiceを呼び出す | E-01 (249行目) | ○ |
| C-02 | unarchiveアクションがUnarchiveServiceを呼び出す | E-02 (257行目) | ○ |
| C-03 | アーカイブ権限チェックがある | E-04 (24行目) | ○ |
| C-04 | 既にアーカイブ済みかチェックする | E-04 (25行目) | ○ |
| C-05 | 先祖がアーカイブ済みかチェックする | E-04 (26行目) | ○ |
| C-06 | 削除予定かチェックする | E-04 (27行目) | ○ |
| C-07 | トランザクション内でアーカイブ処理が行われる | E-05 (43-44行目) | ○ |
| C-08 | project.archive状態遷移メソッドが呼ばれる | E-05 (44行目) | ○ |
| C-09 | archivedフラグがtrueに更新される | E-05 (44行目) | ○ |
| C-10 | システムフックが実行される | E-06 (49行目) | ○ |
| C-11 | イベントが発行される | E-06 (50行目) | ○ |
| C-12 | フォーク関係が解除される | E-06 (52行目) | ○ |
| C-13 | NotAuthorizedErrorが定義されている | E-03 (7-9行目) | ○ |
| C-14 | AlreadyArchivedErrorが定義されている | E-03 (10-12行目) | ○ |
| C-15 | AncestorAlreadyArchivedErrorが定義されている | E-03 (13-15行目) | ○ |
| C-16 | 機能No.4がプロジェクトアーカイブ機能 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] UnarchiveServiceの処理がArchiveServiceと対称的かを確認
- [ ] フォーク解除の副作用について理解されているか確認
- [ ] アーカイブ状態でのCI/CD挙動が文書化されているか確認
