---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：41-マイルストーン管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：ソースコードから直接導出できない要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/milestone.rb`
- E-02: `app/controllers/projects/milestones_controller.rb`
- E-03: `app/services/milestones/create_service.rb`
- E-04: `app/services/milestones/update_service.rb`
- E-05: `app/services/milestones/destroy_service.rb`
- E-06: `app/finders/milestones_finder.rb`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | マイルストーンはプロジェクトまたはグループに属する | E-01 (22-23行目: belongs_to :project, belongs_to :group) | ○ |
| C-02 | マイルストーンはActive/Closedの状態を持つ | E-01 (93-105行目: state_machine定義) | ○ |
| C-03 | タイトルは必須項目 | E-01 (85行目: validates :title, presence: true) | ○ |
| C-04 | タイトルはスコープ内でユニーク | E-01 (88行目: validate :uniqueness_of_title, 330-339行目) | ○ |
| C-05 | 入力パラメータはtitle, description, start_date, due_date, state_event, lock_version | E-02 (182-191行目: milestone_params) | ○ |
| C-06 | 作成時にCreateServiceが呼ばれる | E-02 (62行目: Milestones::CreateService.new) | ○ |
| C-07 | 更新時にUpdateServiceが呼ばれる | E-02 (76行目: Milestones::UpdateService.new) | ○ |
| C-08 | 削除時にDestroyServiceが呼ばれる | E-02 (141行目: Milestones::DestroyService.new) | ○ |
| C-09 | 作成時にスパムチェックが実行される | E-03 (20-22行目: milestone.check_for_spam) | ○ |
| C-10 | 作成時にWebhookが実行される | E-03 (12行目: execute_hooks) | ○ |
| C-11 | 更新時に状態変更(activate/close)が可能 | E-04 (6-13行目: state_event処理) | ○ |
| C-12 | 更新時にイベントがパブリッシュされる | E-04 (17行目, 28-37行目: publish_event) | ○ |
| C-13 | 削除時に関連イシューのmilestone_idがnullになる | E-05 (23-38行目: update_issues) | ○ |
| C-14 | 削除時に関連MRのmilestone_idがnullになる | E-05 (54-62行目: update_merge_requests) | ○ |
| C-15 | 削除はトランザクション内で実行される | E-05 (8行目: Milestone.transaction) | ○ |
| C-16 | 削除時のバッチサイズは500件 | E-05 (5行目: BATCH_SIZE = 500) | ○ |
| C-17 | 楽観的ロック競合時にConflictエラーが返る | E-02 (97-114行目: ActiveRecord::StaleObjectError rescue) | ○ |
| C-18 | admin_milestone権限でCRUD操作が制限される | E-02 (17行目: before_action :authorize_admin_milestone!) | ○ |
| C-19 | read_milestone権限で閲覧が制限される | E-02 (14行目: before_action :authorize_read_milestone!) | ○ |
| C-20 | promote操作でグループマイルストーンへ昇格できる | E-02 (117-131行目: promote action) | ○ |
| C-21 | MilestoneFinderで検索・フィルタリングが行われる | E-06 (28-41行目: execute メソッド) | ○ |
| C-22 | ソートオプションにdue_date_asc/descなどがある | E-06 (87-95行目: order メソッド), E-01 (177-197行目: sort_by_attribute) | ○ |
| C-23 | iidはプロジェクト/グループスコープで自動採番される | E-01 (29-30行目: has_internal_id) | ○ |
| C-24 | リリースとの関連はmilestone_releasesテーブルで管理 | E-01 (25-26行目: has_many :milestone_releases, has_many :releases) | ○ |
| C-25 | パフォーマンス要件（一覧1秒以内、作成500ms以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値（1秒以内、500ms以内）はソースコードから直接導出できない
  - 候補：SLAドキュメント / 性能テスト仕様書 / 運用要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ほとんどの主張がソースコードで裏付け可能
- パフォーマンス要件は運用環境に依存するため、実測値による検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] タイトルの一意性検証ロジック（グループ階層を含む）が正しく理解されているか
- [ ] 削除時のトランザクション処理が適切に説明されているか
- [ ] promote機能の権限要件（親グループのadmin_milestone）が正しいか
- [ ] パフォーマンス要件は実際のSLA/要件と一致しているか確認
