---
generated_at: 2026-01-22 12:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-イシューリンク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/issue_link.rb`
- E-02: `app/models/concerns/issuable_link.rb`
- E-03: `app/models/concerns/linkable_item.rb`
- E-04: `app/controllers/projects/issue_links_controller.rb`
- E-05: `app/services/issuable_links/create_service.rb`
- E-06: `app/services/issue_links/create_service.rb`
- E-07: `app/services/issue_links/list_service.rb`
- E-08: `app/services/issue_links/destroy_service.rb`
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IssueLink はsource とtarget のIssue を持つ | E-01 (7-8行目: belongs_to :source, :target) | ○ |
| C-02 | 最大リンク数は100件 | E-02 (12行目: MAX_LINKS_COUNT = 100) | ○ |
| C-03 | リンクタイプはrelates_to, blocks, is_blocked_by | E-02 (13行目: TYPE_RELATES_TO), EE版で拡張 | ○ |
| C-04 | 自己参照は禁止 | E-02 (49-55行目: check_self_relation) | ○ |
| C-05 | 逆方向の重複リンクは禁止 | E-02 (57-63行目: check_opposite_relation) | ○ |
| C-06 | 親子関係があるイシュー間はリンク不可 | E-03 (26-33行目: check_existing_parent_link) | ○ |
| C-07 | admin_issue_link 権限で作成・削除が制限 | E-04 (7行目: before_action :authorize_admin_issue_link!) | ○ |
| C-08 | 削除時にリンク所属を確認 | E-04 (8行目, 24-26行目: authorize_issue_link_association!) | ○ |
| C-09 | 入力パラメータはlink_type とissuable_references | E-04 (52-54行目: create_params) | ○ |
| C-10 | 作成時にQueryLimiting を無効化 | E-04 (9行目, 16-18行目: disable_query_limit!) | ○ |
| C-11 | CreateService で参照を解析してリンク作成 | E-05 (15-40行目: execute) | ○ |
| C-12 | find_or_initialize_by で重複防止 | E-05 (44行目: link_class.find_or_initialize_by) | ○ |
| C-13 | リンク作成時に双方向システムノートを作成 | E-05 (146-149行目: create_notes) | ○ |
| C-14 | 既存リンクがある場合409 Conflict | E-05 (19-21行目: render_conflict_error?) | ○ |
| C-15 | 権限がない場合403 Forbidden | E-05 (23-25行目: render_no_permission_error?) | ○ |
| C-16 | 対象が見つからない場合404 Not Found | E-05 (27-29行目: render_not_found_error?) | ○ |
| C-17 | ReferenceExtractor で参照文字列を解析 | E-05 (108-116行目: extract_references) | ○ |
| C-18 | 作成成功時にGraphQL通知を発行 | E-06 (7-9行目: GraphqlTriggers.work_item_updated) | ○ |
| C-19 | 削除には両方のイシューの権限が必要 | E-08 (14-16行目: permission_to_remove_relation?) | ○ |
| C-20 | 削除成功時にGraphQL通知を発行 | E-08 (7-9行目: GraphqlTriggers.work_item_updated) | ○ |
| C-21 | ListService でrelated_issues を取得 | E-07 (9-11行目: child_issuables) | ○ |
| C-22 | LinkedProjectIssueSerializer でシリアライズ | E-07 (14-16行目: serializer) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能
- EE版のリンクタイプ拡張（blocks/is_blocked_by）については別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 親子関係チェック（check_existing_parent_link）のロジックが正しく理解されているか
- [ ] クロスプロジェクトリンクの権限チェックが正しいか
- [ ] EE版のリンクタイプ拡張が考慮されているか
