---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-タイムトラッキング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/timelog.rb`
- E-02: `app/models/concerns/time_trackable.rb`
- E-03: `app/services/timelogs/create_service.rb`
- E-04: `app/services/timelogs/delete_service.rb`
- E-05: `app/finders/timelogs/timelogs_finder.rb`
- E-06: `app/controllers/time_tracking/timelogs_controller.rb`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 最大合計時間は1年（31,557,600秒） | E-01 (6行目: MAX_TOTAL_TIME_SPENT = 31557600) | ○ |
| C-02 | time_spent, user, namespace は必須 | E-01 (15行目: validates presence) | ○ |
| C-03 | summary は最大255文字 | E-01 (16行目: validates :summary, length: { maximum: 255 }) | ○ |
| C-04 | issue または merge_request のいずれか一方に関連付け | E-01 (17行目: ExactlyOnePresentValidator) | ○ |
| C-05 | 合計時間が範囲内であることをチェック | E-01 (71-76行目: check_total_time_spent_is_within_range) | ○ |
| C-06 | Timelog は issue, merge_request, project, user, note に belongs_to | E-01 (20-26行目) | ○ |
| C-07 | TimeTrackable concern で時間追跡機能を提供 | E-02 (全体) | ○ |
| C-08 | spend_time メソッドでタイムログを作成 | E-02 (45-61行目: spend_time) | ○ |
| C-09 | total_time_spent は timelogs.sum(:time_spent) で計算 | E-02 (65-73行目: total_time_spent) | ○ |
| C-10 | 合計時間は MAX_TOTAL_TIME_SPENT でclamp | E-02 (72行目: sum.clamp) | ○ |
| C-11 | 減算時間が合計を超える場合エラー | E-02 (129-135行目: check_negative_time_spent) | ○ |
| C-12 | time_estimate は0以上でなければならない | E-02 (143-149行目: check_time_estimate) | ○ |
| C-13 | CreateService で create_timelog 権限をチェック | E-03 (17-22行目) | ○ |
| C-14 | spent_at が未来の場合エラー | E-03 (24行目: spent_at.future?) | ○ |
| C-15 | time_spent が0の場合エラー | E-03 (25行目: time_spent == 0) | ○ |
| C-16 | 作成成功時にSystemNoteService.created_timelog を呼び出し | E-03 (47行目) | ○ |
| C-17 | 作成成功時にWebhook（execute_hooks）を呼び出し | E-03 (49行目) | ○ |
| C-18 | DeleteService で admin_timelog 権限をチェック | E-04 (14-16行目) | ○ |
| C-19 | 削除成功時にSystemNoteService.remove_timelog を呼び出し | E-04 (23行目) | ○ |
| C-20 | TimelogsFinder で時間、ユーザー、グループ、プロジェクトでフィルタ可能 | E-05 (12-20行目: execute) | ○ |
| C-21 | 開始時間と終了時間の逆転をチェック | E-05 (69-73行目: validate_time_difference!) | ○ |
| C-22 | グローバルタイムトラッキングレポートはフィーチャーフラグで制御 | E-06 (9行目: Feature.enabled?(:global_time_tracking_report)) | ○ |
| C-23 | ソート可能なフィールド: spent_at_asc/desc, time_spent_asc/desc | E-01 (59-67行目: sort_by_field) | ○ |
| C-24 | namespace_id は issuable から自動設定 | E-01 (82-88行目: ensure_namespace_id) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能

## 6) レビュアーチェックリスト（最小）
- [ ] 時間形式の変換ロジック（TimeTrackingFormatter）が正しく理解されているか
- [ ] 負の時間によるリセット処理の仕組みが正しいか
- [ ] グローバルタイムトラッキングレポートの機能範囲が正しいか
