---
generated_at: 2026-01-22 13:25:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-インシデント管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/concerns/incident_management/escalatable.rb`
- E-02: `app/models/incident_management/issuable_escalation_status.rb`
- E-03: `app/models/incident_management/timeline_event.rb`
- E-04: `app/controllers/projects/incidents_controller.rb`
- E-05: `app/services/incident_management/incidents/create_service.rb`
- E-06: `app/services/incident_management/timeline_events/create_service.rb`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エスカレーションステータスは4種類（triggered/acknowledged/resolved/ignored） | E-01 (16-21行目: STATUSES) | ○ |
| C-02 | ステータス初期値はtriggered | E-01 (41行目: state_machine :status, initial: :triggered) | ○ |
| C-03 | オープンステータスはtriggeredとacknowledged | E-01 (30行目: OPEN_STATUSES) | ○ |
| C-04 | resolved時にresolved_atが設定される | E-01 (76-79行目: before_transition to: :resolved) | ○ |
| C-05 | resolved以外への遷移時にresolved_atがnilになる | E-01 (72-74行目: before_transition) | ○ |
| C-06 | IssuableEscalationStatusはissueに1対1で紐付く | E-02 (12行目: uniqueness: true) | ○ |
| C-07 | TimelineEventはproject, incident, occurred_atが必須 | E-03 (19行目: validates presence) | ○ |
| C-08 | actionは最大128文字 | E-03 (20行目: validates :action, length: { maximum: 128 }) | ○ |
| C-09 | user_input時のnoteは最大280文字 | E-03 (22行目: validates :note, length: { maximum: 280 }, on: :user_input) | ○ |
| C-10 | 通常のnoteは最大10,000文字 | E-03 (23行目: validates :note, length: { maximum: 10_000 }) | ○ |
| C-11 | インシデント一覧でread_issue権限が必要 | E-04 (8行目: before_action :authorize_read_issue!) | ○ |
| C-12 | IssuesFinderにissue_types: :incidentを指定 | E-04 (44行目: issue_types: :incident) | ○ |
| C-13 | インシデント作成時にissue_type = 'incident' | E-05 (6行目: ISSUE_TYPE = 'incident', 24行目) | ○ |
| C-14 | インシデント作成はIssues::CreateServiceに委譲 | E-05 (18-29行目) | ○ |
| C-15 | severityパラメータでデフォルト重大度設定 | E-05 (8行目: severity: IssuableSeverity::DEFAULT) | ○ |
| C-16 | perform_spam_check: falseでスパムチェックをスキップ | E-05 (28行目) | ○ |
| C-17 | create_incidentでインシデント作成時の自動タイムラインイベント | E-06 (19-25行目) | ○ |
| C-18 | reopen_incidentで再オープン時の自動タイムラインイベント | E-06 (27-33行目) | ○ |
| C-19 | resolve_incidentで解決時の自動タイムラインイベント | E-06 (35-41行目) | ○ |
| C-20 | change_incident_statusでステータス変更時の自動タイムラインイベント | E-06 (43-50行目) | ○ |
| C-21 | change_severityで重大度変更時の自動タイムラインイベント | E-06 (52-59行目) | ○ |
| C-22 | デフォルトactionは'comment' | E-06 (5行目: DEFAULT_ACTION = 'comment') | ○ |
| C-23 | auto_created時は権限チェックをスキップ | E-06 (120-124行目: allowed?) | ○ |
| C-24 | 存在しないタグはエラー（定義済みタグを除く） | E-06 (155-166行目: validate_tags) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能

## 6) レビュアーチェックリスト（最小）
- [ ] エスカレーションステータスの状態遷移が正しく理解されているか
- [ ] 自動タイムラインイベントの生成タイミングが正しいか
- [ ] EE版のエスカレーションポリシー機能の影響を考慮しているか
