---
generated_at: 2026-01-22 13:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-ワークアイテム管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/work_item.rb`
- E-02: `app/models/work_items/type.rb`
- E-03: `app/models/work_items/parent_link.rb`
- E-04: `app/models/work_items/widget_definition.rb`
- E-05: `app/models/work_items/widgets/hierarchy.rb`
- E-06: `app/controllers/projects/work_items_controller.rb`
- E-07: `app/services/work_items/create_service.rb`
- E-08: `app/services/work_items/update_service.rb`
- E-09: `app/services/work_items/delete_service.rb`
- E-10: `app/services/work_items/parent_links/create_service.rb`
- E-11: `app/finders/work_items/work_items_finder.rb`
- E-12: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WorkItemはIssueを継承 | E-01 (3行目: class WorkItem < Issue) | ○ |
| C-02 | WorkItemはissuesテーブルを使用 | E-01 (14行目: self.table_name = 'issues') | ○ |
| C-03 | WorkItemは親子関係を持つ（parent_link, child_links） | E-01 (21-30行目) | ○ |
| C-04 | ウィジェットはwidget_definitionsから取得 | E-01 (330-336行目: widget_definitions) | ○ |
| C-05 | 機密ワークアイテムの子は全て機密必須 | E-01 (438-440行目: parent_link_confidentiality) | ○ |
| C-06 | タイプは9種類（issue, incident, test_case, requirement, task, objective, key_result, epic, ticket） | E-02 (34-44行目: BASE_TYPES) | ○ |
| C-07 | 変更可能なタイプはissue, incident, test_case | E-02 (49行目: CHANGEABLE_BASE_TYPES) | ○ |
| C-08 | タイプ名は最大255文字 | E-02 (72行目: validates :name, length: { maximum: 255 }) | ○ |
| C-09 | allowed_child_typesで許可された子タイプを取得 | E-02 (143-149行目: allowed_child_types) | ○ |
| C-10 | allowed_parent_typesで許可された親タイプを取得 | E-02 (151-157行目: allowed_parent_types) | ○ |
| C-11 | ParentLinkの最大子数は5000 | E-03 (10行目: MAX_CHILDREN = 5000) | ○ |
| C-12 | ParentLinkはwork_item_idがユニーク（親は1つのみ） | E-03 (16行目: validates :work_item, presence: true, uniqueness: true) | ○ |
| C-13 | 循環参照チェックを実施 | E-03 (99-109行目: validate_cyclic_reference) | ○ |
| C-14 | 階層制限をHierarchyRestrictionで検証 | E-03 (74-88行目: validate_hierarchy_restrictions) | ○ |
| C-15 | 機密親の子は機密必須 | E-03 (62-71行目: validate_confidentiality) | ○ |
| C-16 | 関連リンクと親子リンクの重複禁止 | E-03 (111-118行目: check_existing_related_link) | ○ |
| C-17 | ウィジェットタイプは30種類以上定義 | E-04 (24-55行目: enum :widget_type) | ○ |
| C-18 | ウィジェット定義名は最大255文字 | E-04 (11行目: validates :name, length: { maximum: 255 }) | ○ |
| C-19 | available_widgetsでenabledなウィジェット取得 | E-04 (59-61行目: def self.available_widgets) | ○ |
| C-20 | Hierarchyウィジェットでparent, children, ancestors取得可能 | E-05 (8-21行目) | ○ |
| C-21 | Hierarchyのクイックアクション: set_parent, add_child, remove_parent, remove_child | E-05 (39-44行目: quick_action_commands, quick_action_params) | ○ |
| C-22 | CSVインポートに対応（.csv拡張子） | E-06 (8行目: EXTENSION_ALLOWLIST = %w[csv]) | ○ |
| C-23 | インポートにはimport_work_items権限が必要 | E-06 (94行目: can?(current_user, :import_work_items, project)) | ○ |
| C-24 | CreateServiceはIssues::CreateServiceを継承 | E-07 (4行目: class CreateService < Issues::CreateService) | ○ |
| C-25 | 作成にはcreate_work_item権限が必要 | E-07 (43-45行目: authorization_action :create_work_item) | ○ |
| C-26 | UpdateServiceはIssues::UpdateServiceを継承 | E-08 (4行目: class UpdateService < ::Issues::UpdateService) | ○ |
| C-27 | DeleteServiceはdelete_work_item権限をチェック | E-09 (6行目: current_user.can?(:delete_work_item, work_item)) | ○ |
| C-28 | WorkItemsFinderはIssuesFinderを継承 | E-11 (15行目: class WorkItemsFinder < IssuesFinder) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能

## 6) レビュアーチェックリスト（最小）
- [ ] ウィジェットシステムの拡張性が正しく理解されているか
- [ ] 階層構造の深度制限の仕組みが正しいか
- [ ] EE版の追加タイプ・ウィジェットの影響を考慮しているか
- [ ] GraphQL APIの実装詳細が設計書に反映されているか
