---
generated_at: 2026-01-22 13:50:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-パイプライン実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/ci/pipeline.rb`
- E-02: `app/controllers/projects/pipelines_controller.rb`
- E-03: `app/services/ci/create_pipeline_service.rb`
- E-04: `app/services/ci/retry_pipeline_service.rb`
- E-05: `app/services/ci/cancel_pipeline_service.rb`
- E-06: `app/finders/ci/pipelines_finder.rb`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パイプラインテーブル名はp_ci_pipelines | E-01 (23行目: self.table_name = :p_ci_pipelines) | ○ |
| C-02 | MAX_REF_LENGTH = 300 | E-01 (30行目) | ○ |
| C-03 | MAX_SHA_LENGTH = 64 | E-01 (29行目) | ○ |
| C-04 | YAML_ERRORS_MAX_LENGTH = 100KB | E-01 (28行目: YAML_ERRORS_MAX_LENGTH = 100.kilobytes) | ○ |
| C-05 | DEFAULT_CONFIG_PATH = '.gitlab-ci.yml' | E-01 (36行目) | ○ |
| C-06 | COUNT_FAILED_JOBS_LIMIT = 101 | E-01 (40行目) | ○ |
| C-07 | INPUTS_LIMIT = 20 | E-01 (41行目) | ○ |
| C-08 | sha, ref, statusは必須（インポート時除く） | E-01 (177-185行目: validates) | ○ |
| C-09 | MRパイプラインはタグ不可 | E-01 (179行目: validates :tag, inclusion: { in: [false], if: :merge_request? }) | ○ |
| C-10 | 状態機械の初期状態はcreated | E-01 (216行目: state_machine :status, initial: :created) | ○ |
| C-11 | running開始時にstarted_atを設定 | E-01 (278-280行目: before_transition) | ○ |
| C-12 | success/failed/canceled時にfinished_atを設定 | E-01 (282-285行目: before_transition) | ○ |
| C-13 | 完了後にPipelineFinishedWorkerを実行 | E-01 (311行目: Ci::PipelineFinishedWorker.perform_async) | ○ |
| C-14 | success後にDailyBuildGroupReportResultsWorkerを10分後に実行 | E-01 (320行目: perform_in(10.minutes)) | ○ |
| C-15 | cancelableはCANCELABLE_STATUSESとinternal_pipeline | E-01 (843-844行目: cancelable?) | ○ |
| C-16 | archivedはarchive_builds_older_thanとcreated_atで判定 | E-01 (829-840行目: archived?) | ○ |
| C-17 | protected_refはマージリクエスト判定あり | E-01 (1034-1038行目: protected_ref?) | ○ |
| C-18 | PipelinesControllerのPOLLING_INTERVALは10秒 | E-02 (47行目: POLLING_INTERVAL = 10_000) | ○ |
| C-19 | 作成にはcreate_pipeline権限が必要 | E-02 (21行目: authorize_create_pipeline!) | ○ |
| C-20 | 更新にはupdate_pipeline権限が必要 | E-02 (22行目, 307-308行目: authorize_update_pipeline!) | ○ |
| C-21 | キャンセルにはcancel_pipeline権限が必要 | E-02 (23行目, 311-313行目: authorize_cancel_pipeline!) | ○ |
| C-22 | CreatePipelineServiceはSEQUENCEチェーンを実行 | E-03 (10-46行目: SEQUENCE定義) | ○ |
| C-23 | LOG_MAX_PIPELINE_SIZE = 2000 | E-03 (8行目) | ○ |
| C-24 | LOG_MAX_CREATION_THRESHOLD = 20秒 | E-03 (9行目) | ○ |
| C-25 | 作成成功時にCi::PipelineCreatedEventを発行 | E-03 (111-113行目: Gitlab::EventStore.publish) | ○ |
| C-26 | RetryPipelineServiceはupdate_pipeline権限をチェック | E-04 (41行目: can?(current_user, :update_pipeline, pipeline)) | ○ |
| C-27 | 再実行時にRetryJobService.clone!を呼び出す | E-04 (16行目) | ○ |
| C-28 | CancelPipelineServiceはcascade_to_childrenで子パイプラインもキャンセル可能 | E-05 (17行目, 133-155行目) | ○ |
| C-29 | safe_cancellation時はinterruptible:trueのジョブのみキャンセル | E-05 (51行目: with_interruptible_true) | ○ |
| C-30 | PipelinesFinderのALLOWED_SCOPESにrunning, pending, finished, branches, tags | E-06 (12-18行目: ALLOWED_SCOPES) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能

## 6) レビュアーチェックリスト（最小）
- [ ] CreatePipelineServiceのChainシーケンスの順序が正しく理解されているか
- [ ] 状態遷移の後処理（Worker呼び出し）が正しいか
- [ ] EE版の追加Chain（セキュリティポリシー等）の影響を考慮しているか
- [ ] パーティショニング（partition_id）の影響が正しく理解されているか
