---
generated_at: 2026-01-22 14:05:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-ジョブ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/ci/build.rb`
- E-02: `app/models/ci/processable.rb`
- E-03: `app/controllers/projects/jobs_controller.rb`
- E-04: `app/services/ci/retry_job_service.rb`
- E-05: `app/services/ci/build_cancel_service.rb`
- E-06: `app/services/ci/build_erase_service.rb`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ci::BuildはCi::Processableを継承 | E-01 (4行目: class Build < Ci::Processable) | ○ |
| C-02 | TOKEN_PREFIX = 'glcbt-' | E-01 (54行目) | ○ |
| C-03 | RUNNERS_STATUS_CACHE_EXPIRATION = 1分 | E-01 (50行目) | ○ |
| C-04 | MAX_PIPELINES_TO_SEARCH = 100 | E-01 (52行目) | ○ |
| C-05 | RUNNER_FEATURESは6種類定義 | E-01 (40-47行目) | ○ |
| C-06 | timeout_sourceは4種類（unknown, project, runner, job） | E-01 (156-161行目: enum :timeout_source) | ○ |
| C-07 | coverageはnumericality検証 | E-01 (165行目: validates :coverage, numericality: true) | ○ |
| C-08 | refは必須 | E-01 (166行目: validates :ref, presence: true) | ○ |
| C-09 | clone_accessorsは各種属性をコピー | E-01 (285-290行目) | ○ |
| C-10 | Ci::ProcessableはCommitStatusを継承 | E-02 (6行目: class Processable < ::CommitStatus) | ○ |
| C-11 | ACTIONABLE_WHEN = manual, delayed | E-02 (12行目) | ○ |
| C-12 | リソースグループがある場合waiting_for_resourceへ遷移 | E-02 (111行目: if: :with_resource_group?) | ○ |
| C-13 | 完了時にリソースを解放 | E-02 (139-147行目: after_transition any => completed_statuses) | ○ |
| C-14 | JobsControllerのPOLLING_INTERVALは10秒 | E-03 (46行目: Gitlab::PollingInterval.set_header(response, interval: 10_000)) | ○ |
| C-15 | retryにはretry_job権限が必要 | E-03 (89行目: can?(current_user, :retry_job, @build)) | ○ |
| C-16 | playにはplay_job権限が必要 | E-03 (107行目: can?(current_user, :play_job, @build)) | ○ |
| C-17 | playはplayable?をチェック | E-03 (108行目: @build.playable?) | ○ |
| C-18 | キャンセルはBuildCancelServiceで処理 | E-03 (120行目: Ci::BuildCancelService.new(@build, current_user, force_param).execute) | ○ |
| C-19 | 消去はBuildEraseServiceで処理 | E-03 (147行目: Ci::BuildEraseService.new(@build, current_user).execute) | ○ |
| C-20 | RetryJobServiceはretryable?をチェック | E-04 (9行目: if job.retryable?) | ○ |
| C-21 | clone!はCi::Build/Ci::Bridgeのみ許可 | E-04 (31行目: raise TypeError unless job.instance_of?(Ci::Build) || job.instance_of?(Ci::Bridge)) | ○ |
| C-22 | clone!はretry_job権限をチェック | E-04 (99-102行目: check_access!) | ○ |
| C-23 | BuildCancelServiceはcancel_build権限をチェック | E-05 (28-30行目: allowed?) | ○ |
| C-24 | force時はmaintainer_accessが必要 | E-05 (32-34行目: allowed_to_force?) | ○ |
| C-25 | BuildEraseServiceはerasable?をチェック | E-06 (13行目: build.erasable?) | ○ |
| C-26 | 消去時にerased_by, erased_at, artifacts_expire_atを更新 | E-06 (44行目: build.update(erased_by:, erased_at:, artifacts_expire_at: nil)) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能

## 6) レビュアーチェックリスト（最小）
- [ ] CommitStatusからの状態継承が正しく理解されているか
- [ ] リソースグループによる排他制御の仕組みが正しいか
- [ ] ジョブトークンの暗号化とパーティション対応が正しいか
- [ ] Runnerとの連携インターフェースが正しく理解されているか
