---
generated_at: 2026-01-22 14:20:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-パイプラインスケジュール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/ci/pipeline_schedule.rb`
- E-02: `app/controllers/projects/pipeline_schedules_controller.rb`
- E-03: `app/services/ci/pipeline_schedules/create_service.rb`
- E-04: `app/services/ci/pipeline_schedules/play_service.rb`
- E-05: `app/services/ci/pipeline_schedules/calculate_next_run_service.rb`
- E-06: `app/workers/pipeline_schedule_worker.rb`
- E-07: `app/workers/run_pipeline_schedule_worker.rb`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | limit_name = 'ci_pipeline_schedules' | E-01 (31行目) | ○ |
| C-02 | limit_scope = :project | E-01 (32行目) | ○ |
| C-03 | SORT_ORDERSは8種類定義 | E-01 (16-29行目) | ○ |
| C-04 | cron検証はcron: trueで実施 | E-01 (40行目: validates :cron, cron: true) | ○ |
| C-05 | cron_timezone検証はcron_timezone: trueで実施 | E-01 (41行目) | ○ |
| C-06 | refは必須 | E-01 (42行目: validates :ref, presence: true) | ○ |
| C-07 | descriptionは必須 | E-01 (43行目: validates :description, presence: true) | ○ |
| C-08 | 入力数はINPUTS_LIMIT（20）まで | E-01 (48-51行目) | ○ |
| C-09 | 変数の重複チェックを実施 | E-01 (44行目: nested_attributes_duplicates) | ○ |
| C-10 | daily_limitはプロジェクト制限から取得 | E-01 (113-115行目: project.actual_limits.limit_for) | ○ |
| C-11 | for_tag?はrefs/tags/で判定 | E-01 (123-127行目) | ○ |
| C-12 | worker_cron_expressionはSettingsから取得 | E-01 (129-131行目) | ○ |
| C-13 | 作成にはcreate_pipeline_schedule権限が必要 | E-02 (11行目, 108-110行目) | ○ |
| C-14 | 更新にはupdate_pipeline_schedule権限が必要 | E-02 (12行目, 116-118行目) | ○ |
| C-15 | 削除にはadmin_pipeline_schedule権限が必要 | E-02 (13行目, 120-122行目) | ○ |
| C-16 | playにレートリミットを適用 | E-02 (8行目, 84-91行目: check_play_rate_limit!) | ○ |
| C-17 | CreateServiceはownerを自動設定 | E-03 (12行目: params.merge(owner: user)) | ○ |
| C-18 | PlayServiceはRunPipelineScheduleWorkerを呼び出す | E-04 (16行目) | ○ |
| C-19 | アーカイブ済みプロジェクトはエラー | E-04 (11-13行目) | ○ |
| C-20 | CalculateNextRunServiceはplan_cronを計算 | E-05 (42-58行目) | ○ |
| C-21 | 日次制限からevery X minutes形式で計算 | E-05 (48行目, 51行目) | ○ |
| C-22 | PipelineScheduleWorkerのLOCK_TTL = 5分 | E-06 (12行目) | ○ |
| C-23 | PipelineScheduleWorkerのBATCH_SIZE = 500 | E-06 (14行目) | ○ |
| C-24 | PipelineScheduleWorkerのDELAY = 7秒 | E-06 (13行目) | ○ |
| C-25 | RunPipelineScheduleWorkerはidempotent | E-07 (14行目) | ○ |
| C-26 | オーナーが無効な場合はdeactivate!を実行 | E-07 (94-97行目: notify_project_owner_and_deactivate_schedule) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能

## 6) レビュアーチェックリスト（最小）
- [ ] CalculateNextRunServiceの計算ロジックが正しく理解されているか
- [ ] プラン別の日次制限の仕組みが正しいか
- [ ] ExclusiveLeaseによる排他制御が正しく理解されているか
- [ ] オーナー無効時の通知・無効化フローが正しいか
