---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-プロジェクト移行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし
  2. なし
  3. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `app/controllers/projects_controller.rb` - transferアクション（137-149行目）
- E-02: `app/services/projects/transfer_service.rb` - TransferServiceクラス全体
- E-03: `app/services/projects/transfer_service.rb` - execute（25-58行目）
- E-04: `app/services/projects/transfer_service.rb` - transfer（86-103行目）
- E-05: `app/services/projects/transfer_service.rb` - proceed_to_transfer（137-183行目）
- E-06: `app/services/projects/transfer_service.rb` - verify_if_container_registry_tags_can_be_handled（106-112行目）
- E-07: `app/services/projects/transfer_service.rb` - project_has_namespaced_npm_packages?（341-346行目）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.5の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | transferアクションがTransferServiceを呼び出す | E-01 (141行目) | ○ |
| C-02 | 移行先名前空間の存在確認がある | E-03 (28-29行目) | ○ |
| C-03 | 同一名前空間チェックがある | E-03 (32-33行目) | ○ |
| C-04 | 元プロジェクト権限チェックがある | E-03 (35-37行目) | ○ |
| C-05 | 移行先権限チェックがある | E-03 (39-41行目) | ○ |
| C-06 | 重複プロジェクトチェックがある | E-04 (92-94行目) | ○ |
| C-07 | CRタグ処理の検証がある | E-06 | ○ |
| C-08 | NPMパッケージスコープ検証がある | E-04 (98-100行目), E-07 | ○ |
| C-09 | トランザクション内で処理される | E-05 (138-172行目) | ○ |
| C-10 | 名前空間と可視性が更新される | E-05 (145行目) | ○ |
| C-11 | 共有ランナー設定が調整される | E-05 (146行目) | ○ |
| C-12 | 移行通知が送信される | E-05 (150行目) | ○ |
| C-13 | ラベル・マイルストーンが移行される | E-05 (152-154行目) | ○ |
| C-14 | アップロードが移動される | E-05 (157行目) | ○ |
| C-15 | CRパスが更新される | E-05 (160-162行目) | ○ |
| C-16 | インテグレーションが再適用される | E-05 (164行目) | ○ |
| C-17 | システムフックが実行される | E-05 (171行目) | ○ |
| C-18 | 権限再計算が非同期で実行される | E-02 (254-272行目) | ○ |
| C-19 | 移行イベントが発行される | E-02 (329-339行目) | ○ |
| C-20 | 機能No.5がプロジェクト移行機能 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的に根拠が十分に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] CRタグ移行のドライラン仕様が最新APIと一致しているか確認
- [ ] NPMパッケージ制限の範囲が正確か確認
- [ ] 権限再計算の非同期処理による一時的なアクセス不可について文書化されているか確認
