---
generated_at: 2026-01-22 14:35:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-CI変数管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/ci/variable.rb`
- E-02: `app/models/ci/group_variable.rb`
- E-03: `app/models/concerns/ci/has_variable.rb`
- E-04: `app/models/concerns/ci/maskable.rb`
- E-05: `app/controllers/projects/settings/ci_cd_controller.rb`
- E-06: `app/controllers/groups/variables_controller.rb`
- E-07: `app/services/ci/change_variables_service.rb`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロジェクト変数のlimit_name = 'project_ci_variables' | E-01 (25行目) | ○ |
| C-02 | プロジェクト変数のlimit_scope = :project | E-01 (26行目) | ○ |
| C-03 | keyはproject_idとenvironment_scopeでユニーク | E-01 (17-20行目: uniqueness scope) | ○ |
| C-04 | descriptionは最大255文字 | E-01 (16行目) | ○ |
| C-05 | グループ変数のlimit_name = 'group_ci_variables' | E-02 (45行目) | ○ |
| C-06 | グループ変数のlimit_scope = :group | E-02 (46行目) | ○ |
| C-07 | variable_typeはenv_var(1)とfile(2) | E-03 (10-13行目: enum :variable_type) | ○ |
| C-08 | keyは必須で最大255文字 | E-03 (15-17行目: validates :key) | ○ |
| C-09 | keyは英数字とアンダースコアのみ | E-03 (18-19行目: format with regex) | ○ |
| C-10 | 暗号化はAES-256-CBC | E-03 (25-29行目: attr_encrypted, algorithm) | ○ |
| C-11 | 暗号化はper_attribute_iv_and_saltモード | E-03 (26行目) | ○ |
| C-12 | secret_valueはvalueのエイリアス | E-03 (31-32行目) | ○ |
| C-13 | to_hash_variableでジョブ用変数に変換 | E-03 (49-55行目) | ○ |
| C-14 | マスクのREGEXは8文字以上でBase64 + 特殊文字 | E-04 (14行目) | ○ |
| C-15 | raw時のマスクは8文字以上で空白なし | E-04 (19行目: MASK_AND_RAW_REGEX) | ○ |
| C-16 | masked_and_raw?でraw時のマスク判定 | E-04 (27-31行目) | ○ |
| C-17 | masked_and_expanded?で通常時のマスク判定 | E-04 (33-37行目) | ○ |
| C-18 | CI/CD設定表示にはadmin_cicd_variables権限が必要 | E-05 (131-139行目: authorize_show_cicd_settings!) | ○ |
| C-19 | 変数制限はPlan.default.actual_limitsから取得 | E-05 (29行目: @variable_limit) | ○ |
| C-20 | 変数はorder_key_ascでソート | E-05 (203行目) | ○ |
| C-21 | audit_project_cicd_settings_accessで監査ログ記録 | E-05 (103-120行目) | ○ |
| C-22 | グループ変数表示にはadmin_group権限が必要 | E-06 (5行目) | ○ |
| C-23 | グループ変数更新にはadmin_cicd_variables権限が必要 | E-06 (6行目) | ○ |
| C-24 | 変数パラメータにvariable_type, key, description等含む | E-06 (54行目) | ○ |
| C-25 | ChangeVariablesServiceはcontainer.updateを呼び出す | E-07 (6行目) | ○ |
| C-26 | グループ変数でfor_groups, for_environment_scope_likeスコープ使用可 | E-02 (24-31行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張がソースコードで裏付け可能）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付け可能

## 6) レビュアーチェックリスト（最小）
- [ ] 暗号化方式（AES-256-CBC）の安全性が適切か
- [ ] 環境スコープのマッチングロジックが正しく理解されているか
- [ ] 保護変数と保護ブランチの関係が正しいか
- [ ] 変数の優先順位（ジョブ > パイプライン > プロジェクト > グループ）が正しいか
