---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：51-Runnerレジストレーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：明示的な設定ファイルでの確認が必要
  2. **監査ログへの記録**：EE機能の可能性があり確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `app/models/ci/runner.rb` - Runnerモデル定義
- E-02: `app/controllers/projects/runners_controller.rb` - コントローラー実装
- E-03: `app/services/ci/runners/create_runner_service.rb` - 作成サービス
- E-04: `app/services/ci/runners/update_runner_service.rb` - 更新サービス
- E-05: `app/services/ci/runners/unregister_runner_service.rb` - 削除サービス
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Runnerには3種類のタイプ（instance/group/project）がある | E-01 (43-47行目 enum :runner_type) | ○ |
| C-02 | ONLINE_CONTACT_TIMEOUTは2時間 | E-01 (68行目) | ○ |
| C-03 | STALE_TIMEOUTは7日間 | E-01 (79行目) | ○ |
| C-04 | タグは最大50個まで | E-01 (94行目 TAG_LIST_MAX_LENGTH) | ○ |
| C-05 | descriptionは最大1024文字 | E-01 (248行目 validates) | ○ |
| C-06 | maximum_timeoutは600秒以上 | E-01 (272-273行目 validates) | ○ |
| C-07 | 権限チェックにbefore_actionを使用 | E-02 (4-19行目) | ○ |
| C-08 | destroyでUnregisterRunnerServiceを呼び出す | E-02 (36-39行目) | ○ |
| C-09 | pause/resumeでUpdateRunnerServiceを呼び出す | E-02 (42-55行目) | ○ |
| C-10 | 登録時にトランザクションを使用 | E-03 (50-53行目) | ○ |
| C-11 | 更新後にtick_runner_queueを呼び出す | E-04 (20行目) | ○ |
| C-12 | 削除はシンプルなdestroyで実行 | E-05 (16行目) | ○ |
| C-13 | REGISTRATION_AVAILABILITY_TIMEは1時間 | E-01 (82行目) | ○ |
| C-14 | runner_projectsはdependent: :destroyで自動削除 | E-01 (99行目) | ○ |
| C-15 | プロジェクトRunnerは少なくとも1プロジェクトが必要 | E-01 (666-667行目 any_project) | ○ |
| C-16 | グループRunnerは正確に1グループが必要 | E-01 (670-671行目 exactly_one_group) | ○ |
| C-17 | トークンは暗号化して保存 | E-01 (22-36行目 add_authentication_token_field) | ○ |
| C-18 | registration_typeにauthenticated_userがある | E-01 (54-57行目 enum :registration_type) | ○ |
| C-19 | 関連画面No.112, 130-132はCI/CD設定とRunner管理 | E-07 | ○ |
| C-20 | 関連画面No.161-164はグループRunner管理 | E-07 | ○ |
| C-21 | 機能一覧No.51はRunnerレジストレーション | E-06 | ○ |
| C-22 | maintenance_noteは最大1024文字 | E-01 (279行目 validates) | ○ |
| C-23 | 名前は最大256文字 | E-01 (247行目 validates) | ○ |
| C-24 | パフォーマンス要件（1秒、2秒） | **根拠なし** | △ |
| C-25 | 監査ログへの操作記録 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は設計書からの推測であり、明示的な設定ファイルでの確認が必要
  - 候補：SLO定義ファイル / パフォーマンステスト設定 / 運用ドキュメント
- 監査ログへの記録はEE機能の可能性があり、FOSS版での実装確認が必要
  - 候補：ee/app/services/ 配下のファイル / AuditEventService

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - パフォーマンス要件は実測値との整合性確認推奨
- 0: 低リスク - 監査ログはEE機能として別途確認で可

## 6) レビュアーチェックリスト（最小）
- [ ] Runner3種類のタイプ説明が実装と一致しているか確認
- [ ] 権限チェックの記述が最新のコードと一致しているか確認
- [ ] バリデーションルールの数値がモデルと一致しているか確認
- [ ] パフォーマンス要件の数値の妥当性を確認
- [ ] 監査ログ機能の有無と実装状況を確認
