---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：52-アーティファクト管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **デフォルト有効期限30日**：設定ファイルでの確認が必要
  2. **監査ログへのダウンロード記録**：EE機能の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/ci/job_artifact.rb` - アーティファクトモデル定義
- E-02: `app/controllers/projects/artifacts_controller.rb` - コントローラー実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクセシビリティは4段階（public/private/none/maintainer） | E-01 (31行目 enum :accessibility) | ○ |
| C-02 | パーティションテーブル（p_ci_job_artifacts）を使用 | E-01 (24行目 self.table_name) | ○ |
| C-03 | ジョブとの関連はbelongs_to :job | E-01 (34-39行目) | ○ |
| C-04 | 統計更新はupdate_project_statisticsで実行 | E-01 (48行目) | ○ |
| C-05 | MAX_EXPOSED_AS_LENGTHは100 | E-01 (19行目) | ○ |
| C-06 | 権限チェックにbefore_actionを使用 | E-02 (13-16行目) | ○ |
| C-07 | downloadアクションでsend_uploadを呼び出す | E-02 (43行目) | ○ |
| C-08 | browseアクションでartifacts_metadata_entryを使用 | E-02 (49行目) | ○ |
| C-09 | rawアクションはzipアーティファクトのみ対応 | E-02 (85行目) | ○ |
| C-10 | keepアクションでkeep_artifacts!を呼び出す | E-02 (96行目) | ○ |
| C-11 | 外部リンク警告はenable_artifact_external_redirect_warning_pageで制御 | E-02 (66行目) | ○ |
| C-12 | build_from_idはjob_idパラメータから取得 | E-02 (144-145行目) | ○ |
| C-13 | build_from_refはref_nameとjob名から取得 | E-02 (158-162行目) | ○ |
| C-14 | file_typeのデフォルトはarchive | E-02 (166行目) | ○ |
| C-15 | 機能一覧No.52はアーティファクト管理 | E-03 | ○ |
| C-16 | 関連画面No.70, 76がアーティファクト関連 | E-04 | ○ |
| C-17 | MAX_PER_PAGEは20 | E-02 (21行目) | ○ |
| C-18 | feature_categoryはjob_artifacts | E-02 (23行目) | ○ |
| C-19 | expired?はexpire_atが過去かどうかで判定 | E-01 (197-199行目) | ○ |
| C-20 | PLAN_LIMIT_PREFIXはci_max_artifact_size_ | E-01 (18行目) | ○ |
| C-21 | デフォルト有効期限30日 | **根拠なし** | △ |
| C-22 | 監査ログへのダウンロード記録 | **根拠なし（EE機能）** | △ |

## 4) 不足情報（Unknown / Missing）
- デフォルト有効期限30日はアプリケーション設定で確認が必要
  - 候補：gitlab.yml / ApplicationSetting / CI設定ドキュメント
- 監査ログへのダウンロード記録はEE機能として別途確認が必要
  - 候補：ee/app/controllers/ 配下のprepend_mod

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - デフォルト有効期限は設定依存のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] アクセシビリティ4段階の説明が正確か確認
- [ ] ファイルタイプのenum値が最新か確認
- [ ] 権限チェックの記述が最新のコードと一致しているか確認
- [ ] デフォルト有効期限の設定値を確認
- [ ] 監査ログ機能の有無と実装状況を確認
