---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：55-環境管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：明示的な設定ファイルでの確認が必要
  2. **Kubernetes連携の詳細**：EE機能の可能性があり確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/environment.rb` - 環境モデル定義
- E-02: `app/controllers/projects/environments_controller.rb` - コントローラー実装
- E-03: `app/services/environments/stop_service.rb` - 停止サービス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LONG_STOPは1週間 | E-01 (12行目) | ○ |
| C-02 | 環境層のenum（production/staging/testing/development/other） | E-01 (197-203行目) | ○ |
| C-03 | state_machineで状態遷移を管理 | E-01 (210-239行目) | ○ |
| C-04 | 状態は3種類（available/stopping/stopped） | E-01 (228-230行目) | ○ |
| C-05 | guess_tierメソッドで環境層を自動推定 | E-01 (614-627行目) | ○ |
| C-06 | 環境名は最大255文字 | E-01 (61-64行目) | ○ |
| C-07 | slugは最大24文字 | E-01 (68-70行目) | ○ |
| C-08 | external_urlは最大255文字 | E-01 (73-75行目) | ○ |
| C-09 | ポーリング間隔は3秒 | E-02 (47行目 interval: 3_000) | ○ |
| C-10 | indexアクションでJSON/HTML対応 | E-02 (39-57行目) | ○ |
| C-11 | stopアクションでStopServiceを呼び出す | E-02 (118行目) | ○ |
| C-12 | cancel_auto_stopでResetAutoStopServiceを呼び出す | E-02 (137-138行目) | ○ |
| C-13 | StopServiceで権限チェックを実行 | E-03 (8-13行目) | ○ |
| C-14 | force停止とstop_with_actions!の分岐がある | E-03 (23-29行目) | ○ |
| C-15 | 機能一覧No.55は環境管理 | E-04 | ○ |
| C-16 | 関連画面No.77-80が環境管理関連 | E-05 | ○ |
| C-17 | feature_categoryはcontinuous_delivery | E-02 (33行目) | ○ |
| C-18 | ReactiveCacheリフレッシュ間隔は1分 | E-01 (14行目) | ○ |
| C-19 | ReactiveCacheライフタイムは55秒 | E-01 (15行目) | ○ |
| C-20 | 環境名はプロジェクト内で一意 | E-01 (61行目) | ○ |
| C-21 | 外部URLのスキームチェックがある | E-01 (579-590行目) | ○ |
| C-22 | set_kas_cookieでKubernetes認証 | E-02 (26行目) | ○ |
| C-23 | パフォーマンス要件（3秒、2秒） | **根拠なし** | △ |
| C-24 | ターミナルアクセスはEE機能 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は設計書からの推測であり、SLO定義で確認が必要
  - 候補：SLO定義ファイル / パフォーマンステスト設定
- ターミナルアクセス機能の詳細はEEモジュールで確認が必要
  - 候補：ee/app/controllers/ 配下のファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - Kubernetes連携はEE機能として別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 環境層のenum値が最新か確認
- [ ] state_machineの状態遷移が正確か確認
- [ ] guess_tierの正規表現パターンが最新か確認
- [ ] ポーリング間隔の設定値を確認
- [ ] ReactiveCacheの設定値を確認
- [ ] ターミナル機能のライセンス要件を確認
