---
generated_at: 2026-01-22 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：56-デプロイメント履歴

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：明示的な設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/deployment.rb` - デプロイメントモデル定義
- E-02: `app/controllers/projects/deployments_controller.rb` - コントローラー実装
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ARCHIVABLE_OFFSETは50000 | E-01 (16行目) | ○ |
| C-02 | VISIBLE_STATUSESはrunning/success/failed/canceled/blocked | E-01 (73行目) | ○ |
| C-03 | FINISHED_STATUSESはsuccess/failed/canceled | E-01 (74行目) | ○ |
| C-04 | UPCOMING_STATUSESはcreated/blocked/running | E-01 (75行目) | ○ |
| C-05 | state_machineでステータス遷移を管理 | E-01 (77-148行目) | ○ |
| C-06 | ステータスは7種類（enum） | E-01 (158-166行目) | ○ |
| C-07 | IIDはプロジェクトスコープ | E-01 (31行目 has_internal_id) | ○ |
| C-08 | before_actionで権限チェック | E-02 (4行目) | ○ |
| C-09 | indexアクションでJSON形式で返却 | E-02 (15-16行目) | ○ |
| C-10 | showアクションでfind_by_iid!を使用 | E-02 (25行目) | ○ |
| C-11 | 機能一覧No.56はデプロイメント履歴 | E-03 | ○ |
| C-12 | 関連画面No.78, 81がデプロイメント関連 | E-04 | ○ |
| C-13 | feature_categoryはcontinuous_delivery | E-02 (7行目) | ○ |
| C-14 | afterパラメータで日時フィルタ | E-02 (13行目) | ○ |
| C-15 | DeploymentSerializerでrepresent_conciseを使用 | E-02 (16行目) | ○ |
| C-16 | deployed_atはsuccessの場合のfinished_at | E-01 (348-351行目) | ○ |
| C-17 | short_shaはCommit.truncate_shaで生成 | E-01 (264-265行目) | ○ |
| C-18 | パフォーマンス要件（1秒、500ms） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は設計書からの推測であり、SLO定義で確認が必要
  - 候補：SLO定義ファイル / パフォーマンステスト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 0: 低リスク - 閲覧専用機能のため影響範囲が限定的

## 6) レビュアーチェックリスト（最小）
- [ ] ステータスの種類が最新か確認
- [ ] state_machineの状態遷移が正確か確認
- [ ] ARCHIVABLE_OFFSETの値が最新か確認
- [ ] シリアライザーの出力フォーマットを確認
- [ ] Jira連携の実装状況を確認
