---
generated_at: 2026-01-22 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：57-デプロイキー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：明示的な設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/deploy_key.rb` - デプロイキーモデル定義
- E-02: `app/controllers/projects/deploy_keys_controller.rb` - コントローラー実装
- E-03: `app/services/deploy_keys/create_service.rb` - 作成サービス
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DeployKeyはKeyモデルを継承（STI） | E-01 (3行目, 9行目) | ○ |
| C-02 | deploy_keys_projectsで多対多関連 | E-01 (11行目) | ○ |
| C-03 | private?メソッドで公開/非公開判定 | E-01 (42-43行目) | ○ |
| C-04 | orphaned?メソッドで孤児状態判定 | E-01 (45-47行目) | ○ |
| C-05 | has_access_to?でプロジェクトアクセス権チェック | E-01 (66-68行目) | ○ |
| C-06 | can_push_to?で書き込み権限チェック | E-01 (70-72行目) | ○ |
| C-07 | searchメソッドでタイトルと鍵で検索 | E-01 (100-111行目) | ○ |
| C-08 | before_actionで権限チェック | E-02 (9-10行目) | ○ |
| C-09 | indexアクションでJSON形式で返却 | E-02 (18-23行目) | ○ |
| C-10 | enabled_keys/available_project_keys/available_public_keysの3種類 | E-02 (26-52行目) | ○ |
| C-11 | createでCreateServiceを呼び出す | E-02 (59行目) | ○ |
| C-12 | enableでEnableDeployKeyServiceを呼び出す | E-02 (80行目) | ○ |
| C-13 | disableでDisableDeployKeyServiceを呼び出す | E-02 (91行目) | ○ |
| C-14 | CreateServiceでDeployKey.createを実行 | E-03 (6行目) | ○ |
| C-15 | 機能一覧No.57はデプロイキー管理 | E-04 | ○ |
| C-16 | 関連画面No.111, 123がデプロイキー関連 | E-05 | ○ |
| C-17 | feature_categoryはcontinuous_delivery | E-02 (14行目) | ○ |
| C-18 | 保護ブランチとの関連がある | E-01 (18行目) | ○ |
| C-19 | 保護タグとの関連がある | E-01 (19行目) | ○ |
| C-20 | パフォーマンス要件（1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は設計書からの推測であり、SLO定義で確認が必要
  - 候補：SLO定義ファイル / パフォーマンステスト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 0: 低リスク - SSH鍵管理は標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] STI継承の実装が正確か確認
- [ ] deploy_keys_projectsの関連設定を確認
- [ ] 権限チェック（admin_project、update_deploy_key）の違いを確認
- [ ] 孤児キー削除のロジックを確認
- [ ] 保護ブランチ/タグとの連携を確認
