---
generated_at: 2026-01-22 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：58-デプロイトークン管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：明示的な設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/deploy_token.rb` - デプロイトークンモデル定義
- E-02: `app/controllers/projects/deploy_tokens_controller.rb` - コントローラー実装
- E-03: `app/services/projects/deploy_tokens/create_service.rb` - 作成サービス
- E-04: `app/services/projects/deploy_tokens/revoke_service.rb` - 失効サービス
- E-05: `app/services/concerns/deploy_token_methods.rb` - 共通メソッド
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AVAILABLE_SCOPESは7種類 | E-01 (9-11行目) | ○ |
| C-02 | GITLAB_DEPLOY_TOKEN_NAMEはgitlab-deploy-token | E-01 (12行目) | ○ |
| C-03 | DEPLOY_TOKEN_PREFIXはgldt- | E-01 (13行目) | ○ |
| C-04 | NOTIFICATION_INTERVALSは3種類（7,30,60日） | E-01 (15-19行目) | ○ |
| C-05 | トークンは暗号化必須 | E-01 (21行目) | ○ |
| C-06 | expires_atのデフォルトはForever.date | E-01 (23行目) | ○ |
| C-07 | deploy_token_typeはgroup_type/project_type | E-01 (50-53行目) | ○ |
| C-08 | activeスコープの条件 | E-01 (59行目) | ○ |
| C-09 | revoke!でrevoked=trueに更新 | E-01 (103-105行目) | ○ |
| C-10 | active?はrevoked=falseかつ期限内 | E-01 (107-109行目) | ○ |
| C-11 | scopesメソッドで有効スコープ取得 | E-01 (115-117行目) | ○ |
| C-12 | usernameデフォルトはgitlab+deploy-token-{id} | E-01 (200-202行目) | ○ |
| C-13 | username形式バリデーション | E-01 (39-45行目) | ○ |
| C-14 | name最大255文字 | E-01 (46行目) | ○ |
| C-15 | before_actionでdestroy_deploy_token権限チェック | E-02 (4行目) | ○ |
| C-16 | revokeアクションでrevoke!呼び出し | E-02 (9-11行目) | ○ |
| C-17 | CreateServiceでcreate_deploy_token_forを呼び出す | E-03 (9行目) | ○ |
| C-18 | RevokeServiceで権限チェックを実行 | E-04 (9行目, 22-24行目) | ○ |
| C-19 | create_deploy_token_forでcreator_idを設定 | E-05 (11行目) | ○ |
| C-20 | 機能一覧No.58はデプロイトークン管理 | E-06 | ○ |
| C-21 | 関連画面No.111がリポジトリ設定 | E-07 | ○ |
| C-22 | パフォーマンス要件（1秒以内） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は設計書からの推測であり、SLO定義で確認が必要
  - 候補：SLO定義ファイル / パフォーマンステスト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 0: 低リスク - トークン管理は標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] AVAILABLE_SCOPESの種類が最新か確認
- [ ] トークン暗号化の実装を確認
- [ ] 有効期限切れ通知の実装を確認
- [ ] RevokeServiceの権限チェックロジックを確認
- [ ] グループトークンとプロジェクトトークンの違いを確認
