---
generated_at: 2026-01-22 11:10:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：59-フィーチャーフラグ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：明示的な設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/operations/feature_flag.rb` - フィーチャーフラグモデル定義
- E-02: `app/models/operations/feature_flags/strategy.rb` - ストラテジーモデル定義
- E-03: `app/controllers/projects/feature_flags_controller.rb` - コントローラー実装
- E-04: `app/services/feature_flags/create_service.rb` - 作成サービス
- E-05: `app/services/feature_flags/update_service.rb` - 更新サービス
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名はoperations_feature_flags | E-01 (11行目) | ○ |
| C-02 | limit_scopeはproject | E-01 (12行目) | ○ |
| C-03 | has_internal_idでIID自動採番 | E-01 (17行目) | ○ |
| C-04 | activeのデフォルトはtrue | E-01 (19行目) | ○ |
| C-05 | versionのデフォルトはnew_version_flag | E-01 (20行目) | ○ |
| C-06 | フラグ名は2-63文字 | E-01 (30行目) | ○ |
| C-07 | フラグ名のフォーマット検証 | E-01 (31-35行目) | ○ |
| C-08 | descriptionは最大255文字 | E-01 (38行目) | ○ |
| C-09 | enum versionはnew_version_flag: 2 | E-01 (49-51行目) | ○ |
| C-10 | for_unleash_clientメソッドがある | E-01 (62-68行目) | ○ |
| C-11 | reference_prefixは[feature_flag: | E-01 (70-72行目) | ○ |
| C-12 | ストラテジーは5種類 | E-02 (6-17行目) | ○ |
| C-13 | STICKINESS_SETTINGSは4種類 | E-02 (19行目) | ○ |
| C-14 | percentageは0-100の文字列 | E-02 (91-93行目) | ○ |
| C-15 | groupIdは小文字1-32文字 | E-02 (95-97行目) | ○ |
| C-16 | before_actionで操作別権限チェック | E-03 (6-9行目) | ○ |
| C-17 | ポーリング間隔は10秒 | E-03 (26行目, 38行目) | ○ |
| C-18 | ページネーションは30件/ページ | E-03 (21行目) | ○ |
| C-19 | createでCreateServiceを呼び出す | E-03 (46行目) | ○ |
| C-20 | updateでUpdateServiceを呼び出す | E-03 (62行目) | ○ |
| C-21 | destroyでDestroyServiceを呼び出す | E-03 (76行目) | ○ |
| C-22 | CreateServiceで権限チェック | E-04 (6行目, 44-46行目) | ○ |
| C-23 | CreateServiceでバージョン検証 | E-04 (7行目, 48-50行目) | ○ |
| C-24 | UpdateServiceで権限チェック | E-05 (16行目, 110-112行目) | ○ |
| C-25 | UpdateServiceでWebhook実行 | E-05 (43-51行目) | ○ |
| C-26 | 機能一覧No.59はフィーチャーフラグ | E-06 | ○ |
| C-27 | 関連画面No.82, 83がフィーチャーフラグ関連 | E-07 | ○ |
| C-28 | パフォーマンス要件（1秒、500ms） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は設計書からの推測であり、SLO定義で確認が必要
  - 候補：SLO定義ファイル / パフォーマンステスト設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 0: 低リスク - Unleash互換の標準的な実装

## 6) レビュアーチェックリスト（最小）
- [ ] ストラテジーの種類が最新か確認
- [ ] STICKINESS_SETTINGSの値が最新か確認
- [ ] Webhook実行のトリガー条件を確認
- [ ] 監査ログの記録内容を確認
- [ ] プロジェクトごとのフラグ数制限を確認
- [ ] Unleash APIのエンドポイントを確認
