---
generated_at: 2026-01-22 11:15:00
metrics:
  claims_total: 32
  claims_with_evidence: 30
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：60-Kubernetesクラスター連携

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：30 / 32、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の数値**：明示的な設定ファイルでの確認が必要
  2. **EE機能の確認**：一部機能はEEライセンスが必要な可能性

## 2) 参照した情報（Evidence一覧）

- E-01: `app/models/clusters/cluster.rb` - クラスターモデル定義
- E-02: `app/models/clusters/platforms/kubernetes.rb` - Kubernetesプラットフォームモデル
- E-03: `app/controllers/clusters/clusters_controller.rb` - コントローラー実装
- E-04: `app/services/clusters/create_service.rb` - 作成サービス
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DEFAULT_ENVIRONMENTは`*` | E-01 (14行目) | ○ |
| C-02 | MAX_ENVIRONMENT_SCOPE_LENGTHは255 | E-01 (16行目) | ○ |
| C-03 | cluster_typeは3種類 | E-01 (75-79行目) | ○ |
| C-04 | platform_typeはkubernetesのみ | E-01 (81-83行目) | ○ |
| C-05 | provider_typeは3種類（user/gcp/aws） | E-01 (85-89行目) | ○ |
| C-06 | helm_major_versionは2または3 | E-01 (58行目) | ○ |
| C-07 | helm_major_versionデフォルトは3 | E-01 (60行目) | ○ |
| C-08 | state_machine :cleanup_statusがある | E-01 (125-160行目) | ○ |
| C-09 | status_nameメソッドで状態決定 | E-01 (169-174行目) | ○ |
| C-10 | nodesはReactiveCacheから取得 | E-01 (200-204行目) | ○ |
| C-11 | RESERVED_NAMESPACESはgitlab-managed-apps | E-02 (12行目) | ○ |
| C-12 | REQUIRED_K8S_MIN_VERSIONは23 | E-02 (13行目) | ○ |
| C-13 | MAX_TOKEN_LENGTHは8192 | E-02 (15行目) | ○ |
| C-14 | MAX_CA_CERT_LENGTHは65535 | E-02 (16行目) | ○ |
| C-15 | MAX_API_URL_LENGTHは2048 | E-02 (17行目) | ○ |
| C-16 | トークンはAES-256-CBCで暗号化 | E-02 (41-44行目) | ○ |
| C-17 | authorization_typeはrbac/abac | E-02 (73-77行目) | ○ |
| C-18 | predefined_variablesでCI/CD変数生成 | E-02 (94-118行目) | ○ |
| C-19 | STATUS_POLLING_INTERVALは10000 | E-03 (15行目) | ○ |
| C-20 | before_actionで権限チェック | E-03 (6-11行目) | ○ |
| C-21 | ページネーションは20件/ページ | E-03 (161行目) | ○ |
| C-22 | updateでUpdateServiceを呼び出す | E-03 (48-50行目) | ○ |
| C-23 | destroyでDestroyServiceを呼び出す | E-03 (71-73行目) | ○ |
| C-24 | clear_cacheでdelete_cached_resources! | E-03 (93行目) | ○ |
| C-25 | migrateでMigration::CreateServiceを呼び出す | E-03 (99-104行目) | ○ |
| C-26 | CreateServiceでclusterable_paramsを設定 | E-04 (40-50行目) | ○ |
| C-27 | 管理プロジェクト権限検証がある | E-04 (53-56行目) | ○ |
| C-28 | 機能一覧No.60はKubernetesクラスター連携 | E-05 | ○ |
| C-29 | 関連画面No.84-86がKubernetes関連 | E-06 | ○ |
| C-30 | namespaceは1-63文字 | E-02 (49-55行目) | ○ |
| C-31 | パフォーマンス要件（1秒、2秒） | **根拠なし** | △ |
| C-32 | AWS/GCPプロバイダー連携はEE機能 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の数値は設計書からの推測であり、SLO定義で確認が必要
  - 候補：SLO定義ファイル / パフォーマンステスト設定
- AWS/GCPプロバイダー連携の詳細はEEモジュールで確認が必要
  - 候補：ee/app/models/clusters/providers/ 配下のファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードで確認可能
- 1: 中リスク - クラウドプロバイダー連携はEE機能として別途確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] cluster_typeの種類が最新か確認
- [ ] provider_typeの種類が最新か確認
- [ ] REQUIRED_K8S_MIN_VERSIONの値が最新か確認
- [ ] トークン暗号化の実装を確認
- [ ] cleanup_statusの状態遷移を確認
- [ ] ReactiveCachingの設定を確認
- [ ] AWS/GCPプロバイダーのライセンス要件を確認
