---
generated_at: 2026-01-22 12:45:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：61-Terraformステート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の具体的数値**：ドキュメント・設定から明示的な数値が見当たらない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/terraform/state.rb`
- E-02: `app/models/terraform/state_version.rb`
- E-03: `lib/api/terraform/state.rb`
- E-04: `app/services/terraform/remote_state_handler.rb`
- E-05: `app/services/terraform/states/trigger_destroy_service.rb`
- E-06: `app/finders/terraform/states_finder.rb`
- E-07: `app/policies/terraform/state_policy.rb`
- E-08: `app/controllers/projects/terraform_controller.rb`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TerraformステートはHTTPバックエンドとしてGitLabを使用可能 | E-03 (REST APIエンドポイント定義) | ○ |
| C-02 | ステートにはUUIDが32文字の16進数で一意に割り当てられる | E-01 (14-35行目: UUID_LENGTH=32, HEX_REGEXP) | ○ |
| C-03 | ステートのロック機能はlock_xid, locked_by_user, locked_atで管理 | E-01 (15-16行目, 41-43行目), E-04 (31-43行目) | ○ |
| C-04 | バージョニングによりステートの履歴を管理 | E-01 (17-25行目: has_many :versions), E-02 | ○ |
| C-05 | read_terraform_state権限でステート閲覧可能 | E-03 (30行目), E-08 (13-15行目) | ○ |
| C-06 | admin_terraform_state権限でステートの作成・更新・削除が可能 | E-03 (142行目, 183行目, 216行目, 260行目) | ○ |
| C-07 | ステートファイルは暗号化可能 | E-02 (26-31行目: encryption_enabled?メソッド) | ○ |
| C-08 | 論理削除後に非同期ワーカーで物理削除 | E-05 (15-19行目: DestroyWorker.perform_async) | ○ |
| C-09 | ロック中のステートは削除不可 | E-05 (13行目: state_locked_response if state.locked?) | ○ |
| C-10 | CI/CDジョブトークン認証をサポート | E-03 (79-80行目, 139-140行目: job_token_allowed) | ○ |
| C-11 | ステートファイルにはserial(バージョン番号)が必須 | E-03 (156-158行目) | ○ |
| C-12 | 最大ステートサイズはシステム設定に従う | E-03 (115行目, 152-153行目: max_terraform_state_size_bytes) | ○ |
| C-13 | ロックIDの比較にsecure_compareを使用 | E-04 (88-89行目: ActiveSupport::SecurityUtils.secure_compare) | ○ |
| C-14 | オプティミスティックロックを使用 | E-01 (12行目: locking_column = :activerecord_lock_version) | ○ |
| C-15 | 利用状況はp_terraform_state_api_unique_usersでトラッキング | E-03 (32-43行目) | ○ |
| C-16 | feature_categoryはinfrastructure_as_code | E-03 (8行目), E-08 (6行目) | ○ |
| C-17 | レガシーステートからのマイグレーション機能あり | E-01 (73-101行目: migrate_legacy_version!メソッド) | ○ |
| C-18 | Terraform状態一覧画面（画面No.89）が関連画面 | E-09 (130行目) | ○ |
| C-19 | Workhorseによるファイルアップロード処理 | E-03 (99-121行目: authorize, workhorse_authorize) | ○ |
| C-20 | GETリクエストで暗号化/非暗号化で処理が分岐 | E-03 (87-95行目) | ○ |
| C-21 | ステートポリシーはプロジェクトポリシーに委譲 | E-07 (7行目: delegate { terraform_state.project }) | ○ |
| C-22 | force-unlockはlock_idなしでアンロック可能 | E-04 (50-51行目: params[:lock_id].nil?のチェック) | ○ |
| C-23 | ステート削除時にStateDeletedError例外が発生しうる | E-03 (13-18行目), E-04 (8行目, 80行目) | ○ |
| C-24 | StatesFinderでステート検索可能 | E-06 (11-17行目: executeメソッド) | ○ |
| C-25 | パフォーマンス要件として具体的なレスポンス時間の規定がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的数値（レスポンス時間、スループット）
  - 候補：SLA文書 / 運用要件定義書 / パフォーマンステスト仕様書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能仕様はソースコードから十分に確認可能
- 1: 中リスク - パフォーマンス要件の明確化が必要な場合がある

## 6) レビュアーチェックリスト（最小）
- [ ] ステートのロック機構が本番環境で適切に動作することを確認
- [ ] 暗号化設定の有効化状況と暗号化キーの管理方法を確認
- [ ] 最大ステートサイズの設定値が運用要件に適合しているか確認
- [ ] CI/CDジョブトークンの権限設定が適切か確認
- [ ] レガシーステートマイグレーションの影響範囲を確認（14.0以降の運用）
