---
generated_at: 2026-01-22 12:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：62-パッケージレジストリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の詳細数値**：ドキュメントから明示的な数値が見当たらない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/packages/package.rb`
- E-02: `app/models/packages/package_file.rb`
- E-03: `lib/api/project_packages.rb`
- E-04: `app/controllers/projects/packages/packages_controller.rb`
- E-05: `app/finders/packages/packages_finder.rb`
- E-06: `app/services/packages/mark_package_for_destruction_service.rb`
- E-07: `app/controllers/concerns/packages_access.rb`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 15種類のパッケージタイプをサポート（npm, Maven, NuGet等） | E-01 (19-35行目: package_type enum) | ○ |
| C-02 | パッケージステータスはdefault, hidden, processing, error, pending_destruction, deprecatedの6種類 | E-01 (37行目: status enum) | ○ |
| C-03 | パッケージ名+バージョン+タイプの組み合わせがプロジェクト内で一意（Conan除く） | E-01 (55-60行目: validates uniqueness, unless conan?) | ○ |
| C-04 | displayableステータスはdefault, error, deprecatedの3つ | E-01 (13行目: DISPLAYABLE_STATUSES) | ○ |
| C-05 | installableステータスはdefault, hidden, deprecatedの3つ | E-01 (14行目: INSTALLABLE_STATUSES) | ○ |
| C-06 | STIによりパッケージタイプ別クラスへ分岐 | E-01 (133-153行目: inheritance_column_to_class_map) | ○ |
| C-07 | パッケージファイルはCarrierWaveでアップロード管理 | E-02 (153行目: mount_file_store_uploader) | ○ |
| C-08 | プロジェクト統計のpackages_sizeが更新される | E-02 (155行目: update_project_statistics packages_size) | ○ |
| C-09 | API feature_categoryはpackage_registry | E-03 (12行目), E-04 (8行目) | ○ |
| C-10 | read_package権限でパッケージ閲覧可能 | E-07 (17-19行目: can? :read_package) | ○ |
| C-11 | ジョブトークン認証をサポート | E-03 (56行目, 80行目: job_token_allowed) | ○ |
| C-12 | パッケージ一覧はorder_by, sortでソート可能 | E-03 (41-44行目), E-05 (49-51行目: order_packages) | ○ |
| C-13 | package_type, package_name, package_versionでフィルタ可能 | E-03 (45-54行目), E-05 (26-36行目) | ○ |
| C-14 | 削除時に保護ルールをチェック | E-03 (145-154行目: CheckRuleExistenceService) | ○ |
| C-15 | 削除はMarkPackageForDestructionServiceで処理 | E-03 (157行目), E-06 | ○ |
| C-16 | 削除時にpending_destructionステータスに変更 | E-06 (10行目: pending_destruction!) | ○ |
| C-17 | Mavenの場合メタデータ同期を実行 | E-06 (13行目: sync_maven_metadata if maven?) | ○ |
| C-18 | npmの場合メタデータキャッシュ同期を実行 | E-06 (14行目: sync_npm_metadata_cache if npm?) | ○ |
| C-19 | Helmの場合メタデータキャッシュ同期を実行 | E-06 (15行目, 45-49行目: sync_helm_metadata_caches if helm?) | ○ |
| C-20 | Terraform Moduleは通常のパッケージ一覧から除外 | E-05 (58行目: without_package_type(:terraform_module)) | ○ |
| C-21 | パイプライン取得は最大20件/ページ | E-03 (104-106行目: per_page values: 1..20) | ○ |
| C-22 | 大容量ファイルはWorkhorseによるダイレクトアップロード対応 | **根拠なし（推定）** | △ |

## 4) 不足情報（Unknown / Missing）
- Workhorseによるダイレクトアップロードの実装詳細
  - 候補：Workhorseアップローダー設定 / GitLab Workhorse文書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能仕様はソースコードから十分に確認可能
- 1: 中リスク - 各パッケージタイプ別の詳細仕様は個別API確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 各パッケージタイプ（npm, Maven, NuGet等）の固有仕様が要件を満たしているか確認
- [ ] パッケージ保護ルールの設定が適切か確認
- [ ] オブジェクトストレージとの連携設定が正しいか確認
- [ ] プロジェクト統計のpackages_sizeが正確に計算されているか確認
- [ ] パッケージ削除時の非同期処理が確実に実行されるか確認
