---
generated_at: 2026-01-22 13:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：63-コンテナレジストリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **Container Registryサーバー側の設定詳細**：GitLab本体のコードからは確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `app/models/container_repository.rb`
- E-02: `lib/container_registry/tag.rb`
- E-03: `app/controllers/projects/registry/repositories_controller.rb`
- E-04: `app/controllers/projects/registry/tags_controller.rb`
- E-05: `app/services/projects/container_repository/delete_tags_service.rb`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | statusはdelete_scheduled, delete_failed, delete_ongoingの3種類 | E-01 (30行目: enum :status) | ○ |
| C-02 | expiration_policy_cleanup_statusは4種類（0-3） | E-01 (31行目: enum :expiration_policy_cleanup_status) | ○ |
| C-03 | タグページング上限は2000ページ | E-01 (14行目: MAX_TAGS_PAGES = 2000) | ○ |
| C-04 | 削除失敗リトライ上限は10回 | E-01 (15行目: MAX_DELETION_FAILURES = 10) | ○ |
| C-05 | JWTトークンキャッシュは有効期限から5秒差し引き | E-01 (21行目: AUTH_TOKEN_USAGE_RESERVED_TIME_IN_SECS = 5) | ○ |
| C-06 | リポジトリ名はプロジェクト内で一意 | E-01 (26行目: validates :name, uniqueness: { scope: :project_id }) | ○ |
| C-07 | GitLab Registry APIとDocker APIの両対応 | E-01 (119-127行目, 139-153行目: supports_gitlab_api?による分岐) | ○ |
| C-08 | ルートリポジトリの自動作成 | E-03 (44-52行目: ensure_root_container_repository!) | ○ |
| C-09 | リポジトリ削除はdelete_scheduled!でステータス変更 | E-03 (24行目: image.delete_scheduled!) | ○ |
| C-10 | バルク削除上限は15件 | E-04 (10行目: LIMIT = 15, 38-41行目: tag_names.size > LIMIT) | ○ |
| C-11 | タグ削除はdestroy_container_image_tag権限が必要 | E-04 (8行目: authorize_destroy_container_image_tag!) | ○ |
| C-12 | DeleteTagsServiceで削除処理 | E-04 (26-28行目, 43-45行目), E-05 | ○ |
| C-13 | 削除リトライ間隔は指数バックオフ（2^n分） | E-01 (359-361行目: 2**failed_deletion_count).minutes) | ○ |
| C-14 | GitLab API対応時とサードパーティで削除サービスが分岐 | E-05 (29-38行目: delete_service分岐) | ○ |
| C-15 | タグにはprotection_ruleによる保護がある | E-02 (156-176行目: protection_rule, protected_for_delete?) | ○ |
| C-16 | 管理者は保護ルールをバイパス可能 | E-02 (172行目: user.can_admin_all_resources?) | ○ |
| C-17 | タグのdigestはmanifest_digestまたはAPI取得 | E-02 (70-74行目: @manifest_digest || client.repository_tag_digest) | ○ |
| C-18 | タグのcreated_atはconfigから取得 | E-02 (92-102行目: config['created']) | ○ |
| C-19 | コンテナレジストリ画面が関連画面（画面No.96） | E-06 | ○ |
| C-20 | Container Registryサーバーは別プロセスで動作 | **ドキュメント・設定参照** | △ |

## 4) 不足情報（Unknown / Missing）
- Container Registryサーバーの設定・デプロイ詳細
  - 候補：GitLab Container Registry文書 / インフラ設定ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能仕様はソースコードから十分に確認可能
- 1: 中リスク - Container Registryサーバー側の設定・運用については別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Container Registryサーバーの設定が正しいか確認
- [ ] JWTトークンの有効期限設定が適切か確認
- [ ] タグ保護ルールが要件を満たしているか確認
- [ ] 有効期限ポリシーの設定が運用要件に適合しているか確認
- [ ] 削除リトライの上限・間隔が適切か確認
