---
generated_at: 2026-01-22 13:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-Helmチャート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠があり、優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lib/api/helm_packages.rb`
- E-02: `app/models/packages/helm/package.rb`
- E-03: `app/models/packages/helm/file_metadatum.rb`
- E-04: `app/finders/packages/helm/packages_finder.rb`
- E-05: `app/services/packages/helm/process_file_service.rb`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | パッケージファイル名はpackage.tgz | E-01 (14行目: PACKAGE_FILENAME = 'package.tgz') | ○ |
| C-02 | チャネルは正規表現バリデーション | E-01 (63行目), E-03 (17行目) | ○ |
| C-03 | メタデータキャッシュが存在すればキャッシュを返却 | E-01 (72-78行目: if helm_metadata_cache) | ○ |
| C-04 | キャッシュミス時にGenerateMetadataService実行 | E-01 (80-81行目) | ○ |
| C-05 | アップロード時にファイルサイズチェック | E-01 (155行目: helm_max_file_size チェック) | ○ |
| C-06 | アップロード後にExtractionWorkerを非同期実行 | E-01 (173行目: ExtractionWorker.perform_async) | ○ |
| C-07 | Helmパッケージは名前・バージョン形式をバリデーション | E-02 (8-9行目: validates format) | ○ |
| C-08 | チャネルは最大255文字 | E-03 (15行目: length: { maximum: 255 }) | ○ |
| C-09 | メタデータはJSONスキーマでバリデーション | E-03 (19-20行目: json_schema: { filename: "helm_metadata" }) | ○ |
| C-10 | パッケージ上限はhelm_max_packages_countで制限 | E-04 (30-33行目: max_packages_count) | ○ |
| C-11 | 排他ロックのタイムアウトは1時間 | E-05 (12行目: DEFAULT_LEASE_TIMEOUT = 1.hour.to_i) | ○ |
| C-12 | パッケージ保護ルールをチェック | E-05 (22-24行目, 41-52行目: package_protected?) | ○ |
| C-13 | パッケージ処理はトランザクション内で実行 | E-05 (27-31行目: temp_package.transaction) | ○ |
| C-14 | チャート名・バージョンはメタデータから抽出 | E-05 (100-106行目: chart_name, chart_version) | ○ |
| C-15 | ファイル名は{name}-{version}.tgz形式 | E-05 (108-110行目: file_name) | ○ |
| C-16 | リースキーにpackage_file_idを含む | E-05 (114行目: lease_key) | ○ |
| C-17 | 処理完了後にCreateMetadataCacheWorkerを実行 | E-05 (34行目) | ○ |
| C-18 | feature_categoryはpackage_registry | E-01 (11行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] helm_max_file_sizeの設定値が運用要件に適合しているか確認
- [ ] helm_max_packages_countの設定値が適切か確認
- [ ] パッケージ保護ルールが要件を満たしているか確認
- [ ] メタデータキャッシュの更新タイミングが適切か確認
- [ ] 排他ロックのタイムアウト（1時間）が適切か確認
